<?php

    namespace App\Providers;

    use App\SmBackgroundSetting;
    use App\SmGeneralSettings;
    use App\SmNotification;
    use App\SmParent;
    use App\SmRolePermission;
    use App\SmStaff;
    use App\SmStudent;
    use App\SmStyle;
    use App\User;
    use Illuminate\Support\Facades\Auth;
    use Illuminate\Support\ServiceProvider;
    use Illuminate\Support\Facades\Schema;


    class AppServiceProvider extends ServiceProvider
    {
        /**
         * Bootstrap any application services.
         *
         * @return void
         */
        public function boot()
        {


            try {
                    
                    $profile = "";
                    $logo = "";
                    $styles = [];
                    $fav = "";
                    $site_title = "";
                    $school_name = "";
                    $css = "";
                    $notifications = [];
                    $childrens = "";
                    $generalSetting = "";


                    $styles = SmStyle::where('active_status', 1)->get();
                    $generalSetting = SmGeneralSettings::find(1);
                    if (!empty($generalSetting->logo)) {
                        $logo = $generalSetting->logo;
                    } else {
                        $logo = 'public/uploads/settings/logo.png';
                    }

                    if (!empty($generalSetting->favicon)) {
                        $fav = $generalSetting->favicon;
                    } else {
                        $fav = 'public/backEnd/img/favicon.png';
                    }
                    if (!empty($generalSetting->site_title)) {
                        $site_title = $generalSetting->site_title;
                    } else {
                        $site_title = 'School Management System';
                    }
                    if (!empty($generalSetting->school_name)) {
                        $school_name = $generalSetting->school_name;
                    } else {
                        $school_name = 'Infix Edu';
                    }

                    $dashboard_background = SmBackgroundSetting::where([['is_default', 1], ['title', 'Dashboard Background']])->first();
                    if (empty($dashboard_background)) {
                        $css = "background: url('/public/backEnd/img/body-bg.jpg')  no-repeat center; background-size: cover; ";
                    } else {
                        if (!empty($dashboard_background->image)) {
                            $css = "background: url('" . url($dashboard_background->image) . "')  no-repeat center; background-size: cover; ";
                        } else {
                            $css = "background:" . $dashboard_background->color;
                        }
                    }


                    $active_style = SmStyle::where('is_active', 1)->first();

                    view()->share(compact('active_style',   'logo', 'styles', 'fav', 'site_title', 'school_name', 'css',
                        'notifications', 'generalSetting'));
            } catch (\Exception $e) {
                return redirect('login')->with('success-message',$e->getMessage());
            }
        }

        /**
         * Register any application services.
         *
         * @return void
         */
        public function register()
        {
            //
        }
    }
