<?php

    namespace App\Http\Controllers;

    use App\SmGeneralSettings;
    use App\ApiBaseMethod;
    use Illuminate\Http\Request;
    use Illuminate\Support\Facades\Schema;

    use DB;

    class SmApiController extends Controller
    {

        public function checkColumnAvailable(Request $request)
        {
            if (!Schema::hasColumn('sm_general_settings', 'api_url')) {
                Schema::table('sm_general_settings', function($table) {
                    $table->integer('api_url')->default(0);
                });
            }
            $data = SmGeneralSettings::find(1);
            if($data->api_url==0){
                
                if (ApiBaseMethod::checkUrl($request->fullUrl())) {

                    $response = [
                        'success' => false,
                        'data'    => '',
                        'message' => null,
                    ];

                    return $response;
                }
            }else{
                if (ApiBaseMethod::checkUrl($request->fullUrl())) {
                    $data=[];

            $response = [
                'success' => true,
                'data'    => '',
                'message' => null,
            ];
                         return $response;
                }
            }

        }
       
    }