<?php

namespace App\Http\Controllers;

use App\ApiBaseMethod;
use Illuminate\Http\Request;
use App\SmClassRoom;
use Validator;

class SmClassRoomController extends Controller
{

    public function __construct()
    {
        $this->middleware('PM');
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $class_rooms = SmClassRoom::where('active_status', 1)->get();

        if(ApiBaseMethod::checkUrl($request->fullUrl())){
            return ApiBaseMethod::sendResponse($class_rooms, null);
        }
        return view('backEnd.academics.class_room', compact('class_rooms'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $input = $request->all();
        $validator = Validator::make($input, [
            'room_no' => 'required|unique:sm_class_rooms,room_no',
            'capacity' => 'required'
        ]);

        if($validator->fails()){
            if(ApiBaseMethod::checkUrl($request->fullUrl())){
                return ApiBaseMethod::sendError('Validation Error.', $validator->errors());
            }
            return redirect()->back()
                ->withErrors($validator)
                ->withInput();
        }
        $class_room = new SmClassRoom();
        $class_room->room_no = $request->room_no;
        $class_room->capacity = $request->capacity;
        $result = $class_room->save();

        if(ApiBaseMethod::checkUrl($request->fullUrl())){
            if($result){
                return ApiBaseMethod::sendResponse(null, 'Class Room has been created successfully');
            }else{
                return ApiBaseMethod::sendError('Something went wrong, please try again.');
            }
        }else{
            if($result){
                return redirect()->back()->with('message-success', 'Class Room has been created successfully');
            }else{
                return redirect()->back()->with('message-danger', 'Something went wrong, please try again');
            }
        }

    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit(Request $request,$id)
    {
        $class_room = SmClassRoom::find($id);
        $class_rooms = SmClassRoom::where('active_status', 1)->get();

        if(ApiBaseMethod::checkUrl($request->fullUrl())){
            $data=[];
            $data['class_room']= $class_room->toArray();
            $data['class_rooms']= $class_rooms->toArray();
            return ApiBaseMethod::sendResponse($data, null);
        }

        return view('backEnd.academics.class_room', compact('class_room', 'class_rooms'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $input = $request->all();
        $validator = Validator::make($input, [
            'room_no' => 'required|unique:sm_class_rooms,room_no,'.$request->id,
            'capacity' => 'required'
        ]);

        if($validator->fails()){
            if(ApiBaseMethod::checkUrl($request->fullUrl())){
                return ApiBaseMethod::sendError('Validation Error.', $validator->errors());
            }
            return redirect()->back()
                ->withErrors($validator)
                ->withInput();
        }

        $class_room = SmClassRoom::find($request->id);
        $class_room->room_no = $request->room_no;
        $class_room->capacity = $request->capacity;
        $result = $class_room->save();

        if(ApiBaseMethod::checkUrl($request->fullUrl())){
            if($result){
                return ApiBaseMethod::sendResponse(null, 'Class Room has been updated successfully');
            }else{
                return ApiBaseMethod::sendError('Something went wrong, please try again.');
            }
        }else{
            if($result){
                return redirect('class-room')->with('message-success', 'Class Room has been updated successfully');
            }else{
                return redirect()->back()->with('message-danger', 'Something went wrong, please try again');
            }
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy( Request $request,$id)
    {
 
        // $result = SmClassRoom::destroy($id);

        // if(ApiBaseMethod::checkUrl($request->fullUrl())){
        //     if($result){
        //         return ApiBaseMethod::sendResponse(null, 'Class Room has been deleted successfully');
        //     }else{
        //         return ApiBaseMethod::sendError('Something went wrong, please try again.');
        //     }
        // }else{
        //     if($result){
        //         return redirect('class-room')->with('message-success-delete', 'Class Room has been deleted successfully');
        //     }else{
        //         return redirect()->back()->with('message-danger-delete', 'Something went wrong, please try again');
        //     }
        // }
        $id_key='room_id';

        $tables=\App\tableList::getTableList($id_key);
        
        try {
            $delete_query = SmClassRoom::destroy($id);
            if(ApiBaseMethod::checkUrl($request->fullUrl())){
                if($delete_query){
                    return ApiBaseMethod::sendResponse(null, 'Class Room has been deleted successfully');
                }else{
                    return ApiBaseMethod::sendError('Something went wrong, please try again.');
                }
            }else{               
                if($delete_query){
                    return redirect()->back()->with('message-success-delete', 'Class Room has been deleted successfully');
                }else{
                    return redirect()->back()->with('message-danger-delete', 'Something went wrong, please try again');
                }
            }
        
        } catch (\Illuminate\Database\QueryException $e) {
            $msg='This data already used in  : '.$tables.' Please remove those data first';
        
            return redirect()->back()->with('message-danger-delete', $msg);
        } catch (\Exception $e) {
                    //dd($e->getMessage(), $e->errorInfo);
            return redirect()->back()->with('message-danger-delete', 'Something went wrong, please try again');
        }


    }
}
