<?php

namespace App\Http\Controllers;

use App\ApiBaseMethod;
use Illuminate\Http\Request;
use App\SmRoute;
use Validator;
class SmRouteController extends Controller
{
    public function __construct(){
        $this->middleware('PM');
    }
    
   /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $routes = SmRoute::all();

        if (ApiBaseMethod::checkUrl($request->fullUrl())) {
            return ApiBaseMethod::sendResponse($routes, null);
        }
        return view('backEnd.transport.route', compact('routes'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $input = $request->all();
        $validator = Validator::make($input, [
            'title' => 'required|unique:sm_routes,title',
            'far' => "required|integer"
        ]);

        if ($validator->fails()) {
            if (ApiBaseMethod::checkUrl($request->fullUrl())) {
                return ApiBaseMethod::sendError('Validation Error.', $validator->errors());
            }
            return redirect()->back()
                ->withErrors($validator)
                ->withInput();
        }

        $route = new SmRoute();
        $route->title = $request->title;
        $route->far = $request->far;
        $result = $route->save();

        if (ApiBaseMethod::checkUrl($request->fullUrl())) {
            if ($result) {
                return ApiBaseMethod::sendResponse(null, 'Route has been created successfully');
            } else {
                return ApiBaseMethod::sendError('Something went wrong, please try again');
            }
        } else {
            if ($result) {
                return redirect()->back()->with('message-success', 'Route has been created successfully');
            } else {
                return redirect()->back()->with('message-danger', 'Something went wrong, please try again');
            }
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show(Request $request,$id)
    {
        $route = SmRoute::find($id);
        $routes = SmRoute::all();

        if (ApiBaseMethod::checkUrl($request->fullUrl())) {
            $data = [];
            $data['route'] = $route->toArray();
            $data['routes'] = $routes->toArray();
            return ApiBaseMethod::sendResponse($data, null);
        }
        return view('backEnd.transport.route', compact('route', 'routes'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $input = $request->all();
        if (ApiBaseMethod::checkUrl($request->fullUrl())) {
            $validator = Validator::make($input, [
                'title' => 'required|unique:sm_routes,title,'.$id,
                'far' => "required",
                'id'=>'required'
            ]);
        }
        else{
            $validator = Validator::make($input, [
                'title' => 'required|unique:sm_routes,title,'.$id,
                'far' => "required"
            ]);
        }

        if ($validator->fails()) {
            if (ApiBaseMethod::checkUrl($request->fullUrl())) {
                return ApiBaseMethod::sendError('Validation Error.', $validator->errors());
            }
            return redirect()->back()
                ->withErrors($validator)
                ->withInput();
        }
        $route = SmRoute::find($request->id);
        $route->title = $request->title;
        $route->far = $request->far;
        $result = $route->save();
        if (ApiBaseMethod::checkUrl($request->fullUrl())) {
            if ($result) {
                return ApiBaseMethod::sendResponse(null, 'Route has been updated successfully');
            } else {
                return ApiBaseMethod::sendError('Something went wrong, please try again');
            }
        } else {
            if ($result) {
                return redirect('transport-route')->with('message-success', 'Route has been updated successfully');
            } else {
                return redirect()->back()->with('message-danger', 'Something went wrong, please try again');
            }
        }

    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request,$id)
    {
        $tables=\App\tableList::getTableList('route_id');
        try {
        $route = SmRoute::destroy($id);
        if($route){

            if (ApiBaseMethod::checkUrl($request->fullUrl())) {
                if ($route) {
                    return ApiBaseMethod::sendResponse(null, 'Route has been deleted successfully');
                } else {
                    return ApiBaseMethod::sendError('Something went wrong, please try again.');
                }
            } else {
                if ($route) {
                    return redirect()->back()->with('message-success-delete', 'Route has been deleted successfully');
                } else {
                    return redirect()->back()->with('message-danger-delete', 'Something went wrong, please try again');
                }
            }
        }else{
        return redirect()->back()->with('message-danger-delete', 'Something went wrong, please try again');
        }
        } catch (\Illuminate\Database\QueryException $e) {

            $msg='This data already used in  : '.$tables. ' Please remove those data first';
			return redirect()->back()->with('message-danger-delete', $msg);
        } catch (\Exception $e) {
        //dd($e->getMessage(), $e->errorInfo);
        return redirect()->back()->with('message-danger-delete', 'Something went wrong, please try again');
        }
    }
}
