<?php

namespace App\Http\Controllers;

use App\ApiBaseMethod;
use Illuminate\Http\Request;
use App\SmSession;
use App\tableList;
use Validator;
class SmSessionController extends Controller
{
    public function __construct(){
        $this->middleware('PM');
    }
    
   /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $sessions = SmSession::where('active_status', 1)->get();

        if (ApiBaseMethod::checkUrl($request->fullUrl())) {
            return ApiBaseMethod::sendResponse($sessions, null);
        }
        return view('backEnd.systemSettings.session', compact('sessions'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $input = $request->all();
        $validator = Validator::make($input, [
            'session' => "required",
        ]);

        if ($validator->fails()) {
            if (ApiBaseMethod::checkUrl($request->fullUrl())) {
                return ApiBaseMethod::sendError('Validation Error.', $validator->errors());
            }
            return redirect()->back()
                ->withErrors($validator)
                ->withInput();
        }

        $session = new SmSession();
        $session->session = $request->session;
        $result = $session->save();

        if (ApiBaseMethod::checkUrl($request->fullUrl())) {
            if ($result) {
                return ApiBaseMethod::sendResponse(null, 'Session has been created successfully');
            } else {
                return ApiBaseMethod::sendError('Something went wrong, please try again');
            }
        } else {
            if ($result) {
                return redirect()->back()->with('message-success', 'Session has been created successfully');
            } else {
                return redirect()->back()->with('message-danger', 'Something went wrong, please try again');
            }
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show(Request $request,$id)
    {
        $session = SmSession::find($id);
        $sessions = SmSession::all();

        if (ApiBaseMethod::checkUrl($request->fullUrl())) {
            $data = [];
            $data['session'] = $session;
            $data['sessions'] = $sessions->toArray();
            return ApiBaseMethod::sendResponse($data, null);
        }

        return view('backEnd.systemSettings.session', compact('sessions', 'session'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        return 'dsfsd';
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $input = $request->all();
        if (ApiBaseMethod::checkUrl($request->fullUrl())) {
            $validator = Validator::make($input, [
                'session' => "required",
            ]);
        }else{
            $validator = Validator::make($input, [
                'session' => "required",
            ]);
        }

        if ($validator->fails()) {
            if (ApiBaseMethod::checkUrl($request->fullUrl())) {
                return ApiBaseMethod::sendError('Validation Error.', $validator->errors());
            }
            return redirect()->back()
                ->withErrors($validator)
                ->withInput();
        }

        $session = SmSession::find($request->id);
        $session->session = $request->session;
        $result = $session->save();

        if (ApiBaseMethod::checkUrl($request->fullUrl())) {
            if ($result) {
                return ApiBaseMethod::sendResponse(null, 'Session has been updated successfully');
            } else {
                return ApiBaseMethod::sendError('Something went wrong, please try again');
            }
        } else {
            if ($result) {
                return redirect('session')->with('message-success', 'Session has been updated successfully');
            } else {
                return redirect()->back()->with('message-danger', 'Something went wrong, please try again');
            }
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request,$id)
    {

        $foreign_key_id='session_id';

        $tables=tableList::getTableList($foreign_key_id);
        //dd($tables);

            try {
                $delete_query = SmSession::destroy($id);
                //$delete_query = SmSession::destroy($id);
                if(ApiBaseMethod::checkUrl($request->fullUrl())){
                    if($delete_query){
                        return ApiBaseMethod::sendResponse(null, 'Session has been deleted successfully');
                    }else{
                        return ApiBaseMethod::sendError('Something went wrong, please try again.');
                    }
                }else{               
                    if($delete_query){
                        //return $delete_query;
                        return redirect()->back()->with('message-success-delete', 'Session has been deleted successfully');
                    }else{
                        //return $delete_query;
                        return redirect()->back()->with('message-danger-delete', 'Something wrong with Session, please try again');
                    }
                }

            } catch (\Illuminate\Database\QueryException $e) {
                $msg='This data already used in  : '.$tables.' Please remove those data first';

                return redirect()->back()->with('message-danger-delete', $msg);
            } catch (\Exception $e) {
                        //dd($e->getMessage(), $e->errorInfo);
                return redirect()->back()->with('message-danger-delete', 'Something went wrong, please try again');
            }







        
        // $session = SmSession::destroy($id);
        // if (ApiBaseMethod::checkUrl($request->fullUrl())) {
        //     if ($session) {
        //         return ApiBaseMethod::sendResponse(null, 'Session has been deleted successfully');
        //     } else {
        //         return ApiBaseMethod::sendError('Something went wrong, please try again');
        //     }
        // } else {
        //     if ($session) {
        //         return redirect('session')->with('message-success-delete', 'Session has been deleted successfully');
        //     } else {
        //         return redirect()->back()->with('message-danger-delete', 'Something went wrong, please try again');
        //     }
        // }
   
   
   
   
    }
}
