<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
use App\SmLanguagePhrase;

class CreateSmLanguagePhrasesTable extends Migration
{
/**
 * Run the migrations.
 *
 * @return void
 */
public function up()
{
	Schema::create('sm_language_phrases', function (Blueprint $table) {
		$table->collation = 'utf8_general_ci';
		$table->charset = 'utf8';
		$table->increments('id');
		$table->text('modules')->nullable();
		$table->text('default_phrases')->nullable();
		$table->text('en')->nullable();
		$table->text('es')->nullable();
		$table->text('fr')->nullable();
		$table->text('bn')->nullable(); 
		$table->tinyInteger('active_status')->default('1'); 
		$table->timestamps(); 
	});
 
	$all_translate = [
		[ 1 , 0 ,'dashboard ',' Dashboard ',' Tablero ',' Tableau de bord ',' ড্যাশবোর্ড'],
		[ 2 , 0 ,'welcome ',' Welcome ',' Bienvenido',' Bienvenue ',' স্বাগত'],
		[ 3 , 0 ,'student ',' Student ',' Estudiante',' Étudiant',' ছাত্র '],
		[ 4 , 0 ,'total ',' Total ',' Total ',' Total ',' মোট '],
		[ 5 , 0 ,'teachers',' Teachers',' Maestros',' Enseignants ',' শিক্ষক'],
		[ 6 , 0 ,'parents ',' Parents ',' Los padres',' Parents ',' মাতাপিতা'],
		[ 7 , 0 ,'staffs',' Staffs',' Personal',' Le personnel',' কর্মীরা '],
		[ 8 , 0 ,'income_and_expenses_for ',' Income and Expenses for ',' Ingresos y gastos para',' Revenus et dépenses pour',' আয় এবং ব্যয় জন্য'],
		[ 9 , 0 ,'total_income',' Total Income',' Ingresos totales',' Revenu total',' মোট আয় '],
		[ 10, 0 ,'total_expenses',' Total Expenses',' Gastos totales',' Dépenses totales',' মোট খরচ '],
		[ 11, 0 ,'total_profit',' Total Profit',' Beneficio total ',' Bénéfice total',' সমস্ত লাভ '],
		[ 12, 0 ,'total_revenue ',' Total Revenue ',' Los ingresos totales',' Revenu total',' মোট রাজস্ব'],
		[ 13, 0 ,'title ',' Title ',' Título',' Titre ',' খেতাব '],
		[ 14, 0 ,'message ',' Message ',' Mensaje ',' Message ',' বার্তা'],
		[ 15, 0 ,'actions ',' Actions ',' Comportamiento',' actes ',' ক্রিয়াকলাপ '],
		[ 16, 0 ,'calendar',' Calendar',' Calendario',' Calendrier',' পাঁজি '],
		[ 17, 0 ,'view',' View',' Ver ',' Vue ',' দৃশ্য '],
		[ 18, 0 ,'to_do_list',' To Do List',' Lista de quehaceres ',' Liste de choses à faire ',' তালিকা তৈরি '],
		[ 19, 0 ,'add ',' Add ',' Añadir',' Ajouter ',' যোগ '],
		[ 20, 0 ,'edit',' Edit',' Editar',' modifier',' সম্পাদন করা '],
		[ 21, 0 ,'no_do_lists_assigned_yet',' No Do Lists Assigned Yet',' No hay listas asignadas aún ',' Aucune liste assignée pour linstant',' না এখনো তালিকাভুক্ত করা তালিকা'],
		[ 22, 1 ,'admin_section ',' Admin Section ',' Sección de Administración ',' Section Admin ',' অ্যাডমিন বিভাগ'],
		[ 23, 1 ,'admission_query ',' Admission Query ',' Consulta de Admisión',' Requête dadmission ',' ভর্তি প্রশ্ন'],
		[ 24, 1 ,'select_criteria ',' Select Criteria ',' Seleccione los criterios',' Sélectionner des critères ',' মাপদণ্ড নির্বাচন করুন '],
		[ 25, 1 ,'date_from ',' Date From ',' Fecha de',' Dater de',' তারিখ হতে '],
		[ 26, 1 ,'date_to ',' Date To ',' Fecha para',' Date à',' তারিখ '],
		[ 27, 1 ,'select_source ',' Select Source ',' Seleccione Fuente ',' Sélectionnez la source',' উৎস নির্বাচন করুন '],
		[ 28, 1 ,'select_status ',' Select status ',' Seleccionar estado',' Sélectionnez le statut',' অবস্থা নির্বাচন করুন'],
		[ 29, 1 ,'Status',' Status',' Estado',' Statut',' অবস্থা'],
		[ 30, 1 ,'active',' Active',' Activo',' actif ',' সক্রিয় '],
		[ 31, 1 ,'inactive',' Inactive',' Inactivo',' Inactif ',' নিষ্ক্রিয়'],
		[ 32, 1 ,'search',' Search',' Buscar',' Chercher',' অনুসন্ধান '],
		[ 33, 1 ,'query_list',' Query List',' Lista de consultas',' Liste de requêtes ',' প্রশ্ন তালিকা '],
		[ 34, 1 ,'name',' Name',' Nombre',' prénom',' নাম '],
		[ 35, 1 ,'phone ',' Phone ',' Teléfono',' Téléphone ',' ফোন '],
		[ 36, 1 ,'source',' Source',' Fuente',' La source ',' সূত্র '],
		[ 37, 1 ,'email ',' Email ',' Email ',' Email ',' ইমেইল '],
		[ 38, 1 ,'query_date',' Query Date',' Fecha de consulta ',' Date de la requête',' প্রশ্ন তারিখ'],
		[ 39, 1 ,'last_follow_up_date ',' last follow up date ',' última fecha de seguimiento ',' dernière date de suivi',' সর্বশেষ ফলো আপ তারিখ'],
		[ 40, 1 ,'next_follow_up_date ',' next follow up date ',' siguiente fecha de seguimiento',' prochaine date de suivi ',' পরবর্তী অনুসরণ তারিখ'],
		[ 41, 1 ,'select',' Select',' Seleccionar ',' Sélectionner',' নির্বাচন করা'],
		[ 42, 1 ,'add_query ',' Add Query ',' Añadir consulta ',' Ajouter une requête ',' প্রশ্ন যোগ করুন '],
		[ 43, 1 ,'delete',' Delete',' Borrar',' Effacer ',' মুছে ফেলা '],
		[ 44, 1 ,'delete_admission_query',' Delete Admission Query',' Eliminar consulta de admisión ',' Supprimer la requête dadmission',' ভর্তি প্রশ্ন মুছে ফেলুন '],
		[ 45, 1 ,'are_you_sure_to_delete',' Are you sure to delete this item? ',' ¿Estás seguro de eliminar este elemento?',' Êtes-vous sûr de vouloir supprimer cet article? ',' আপনি এই আইটেম মুছে ফেলার জন্য নিশ্চিত?'],
		[ 46, 1 ,'cancel',' Cancel',' Cancelar',' Annuler ',' বাতিল '],
		[ 47, 1 ,'admission_enquiry ',' Admission Enquiry ',' Consulta de Admisión',' Enquête dadmission ',' ভর্তি পরীক্ষা '],
		[ 48, 1 ,'address ',' Address ',' Dirección ',' Adresse ',' ঠিকানা'],
		[ 49, 1 ,'description ',' Description ',' Descripción ',' La description',' বিবরণ '],
		[ 50, 1 ,'date',' Date',' Fecha ',' Rendez-vous amoureux',' তারিখ '],
		[ 51, 1 ,'assigned',' Assigned',' Asignado',' Attribué',' বরাদ্দ'],
		[ 52, 1 ,'reference ',' Reference ',' Referencia',' Référence ',' উল্লেখ'],
		[ 53, 1 ,'number_of_child ',' Number of child ',' Numero de niño',' Nombre denfant ',' সন্তানের সংখ্যা '],
		[ 54, 1 ,'save',' Save',' Salvar',' sauvegarder ',' সংরক্ষণ করুন'],
		[ 55, 1 ,'visitor_book',' Visitor Book',' Libro de visitas',' Livre de visites',' ভিজিটর বুক'],
		[ 56, 1 ,'visitor ',' Visitor ',' Visitante ',' Visiteur',' পরিদর্শক'],
		[ 57, 1 ,'purpose ',' Purpose ',' Propósito ',' Objectif',' উদ্দেশ্য'],
		[ 58, 1 ,'id',' Id',' CARNÉ DE IDENTIDAd',' Id',' আইডি'],
		[ 59, 1 ,'no_of_person',' No. of Person ',' No. de persona',' No. de personne ',' ব্যক্তির সংখ্যা '],
		[ 60, 1 ,'in_time ',' In Time ',' A tiempo',' À lheure ',' সময়'],
		[ 61, 1 ,'out_time',' Out time',' Fuera de tiempo ',' Temps de sortie ',' সময় শেষ'],
		[ 62, 1 ,'browse',' browse',' vistazo ',' Feuilleter',' ব্রাউজ'],
		[ 63, 1 ,'update',' Update',' Actualizar',' Mettre à jour ',' হালনাগাদ'],
		[ 64, 1 ,'visitor_list',' Visitor List',' Lista de visitantes ',' Liste de visiteurs',' ভিজিটর তালিকা '],
		[ 65, 1 ,'download',' Download',' Descargar ',' Télécharger ',' ডাউনলোড '],
		[ 66, 1 ,'complaint ',' Complaint ',' Queja ',' Plainte ',' অভিযোগ'],
		[ 67, 1 ,'by',' By',' Por ',' Par ',' দ্বারা'],
		[ 68, 1 ,'type',' Type',' Tipo',' Type',' আদর্শ '],
		[ 69, 1 ,'taken ',' Taken ',' Tomado',' Pris',' ধরা '],
		[ 70, 1 ,'list',' List',' Lista ',' liste ',' তালিকা'],
		[ 71, 1 ,'postal_receive',' Postal Receive',' Recibir Postal',' Réception postale ',' পোস্টাল গ্রহণ '],
		[ 72, 1 ,'from_title',' From Title',' Del título',' De titre',' শিরোনাম থেকে'],
		[ 73, 1 ,'no',' No. ',' No. ',' Non.',' না। '],
		[ 74, 1 ,'note',' Note',' Nota',' Remarque',' বিঃদ্রঃ '],
		[ 75, 1 ,'to_title',' To Title',' Al título ',' Au titre',' শিরোনাম '],
		[ 76, 1 ,'postal_dispatch ',' Postal Dispatch ',' Despacho Postal ',' Envoi postal',' ডাক প্রেরণ'],
		[ 77, 1 ,'phone_call_log',' Phone Call Log',' Registro de llamadas telefónicas',' Journal des appels téléphoniques',' ফোন কল লগ '],
		[ 78, 1 ,'phone_call',' Phone Call',' Llamada telefónica',' Appel téléphonique',' ফোন কল'],
		[ 79, 1 ,'follow_up_date',' Follow Up Date',' Fecha de seguimiento',' Date de suivi ',' আপ অনুসরণ করুন তারিখ'],
		[ 80, 1 ,'call_duration ',' Call Duration ',' Duración de la llamada',' Durée dappel ',' কল সময়কাল'],
		[ 81, 1 ,'incoming',' Incoming',' Entrante',' Entrant ',' ইনকামিং '],
		[ 82, 1 ,'outgoing',' Outgoing',' Saliente',' Sortant ',' বিদায়ী '],
		[ 83, 1 ,'call',' Call',' Llamada ',' Appel ',' কল'],
		[ 84, 1 ,'admin_setup ',' Admin Setup ',' Configuración de administrador',' Configuration de ladministrateur ',' অ্যাডমিন সেটআপ'],
		[ 85, 1 ,'student_certificate ',' Student Certificate ',' Certificado de estudiante ',' Certificat détudiant ',' ছাত্র সার্টিফিকেট '],
		[ 86, 1 ,'certificate ',' Certificate ',' Certificado ',' Certificat',' শংসাপত্র'],
		[ 87, 1 ,'header_left_text',' Header left text',' Encabezado texto a la izquierda ',' En-tête gauche du texte ',' শিরোনাম বাম টেক্সট'],
		[ 88, 1 ,'body',' Body',' Cuerpo',' Corps ',' শরীর'],
		[ 89, 1 ,'footer_left_text',' Footer left text',' Pie de página texto a la izquierda',' Footer left text',' পাদচরণ বাম টেক্সট '],
		[ 90, 1 ,'footer_center_text',' Footer Center text',' Texto del centro de pie de página ',' Footer Center text',' পাদচরণ কেন্দ্র টেক্সট '],
		[ 91, 1 ,'footer_right_text ',' Footer Right text ',' Pie derecho texto ',' Footer Right text ',' পাদচরণ ডান টেক্সট '],
		[ 92, 1 ,'student_photo ',' Student Photo ',' Foto de estudiante',' Photo étudiante ',' ছাত্র ফটো '],
		[ 93, 1 ,'yes ',' yes ',' sí',' Oui ',' হাঁ '],
		[ 94, 1 ,'none',' No',' No',' Non ',' না'],
		[ 95, 1 ,'background_image',' Background Image',' Imagen de fondo ',' Image de fond ',' পটভূমি চিত্র'],
		[ 96, 1 ,'generate_certificate',' Generate Certificate',' Generar certificado ',' Générer un certificat ',' শংসাপত্র তৈরি করুন'],
		[ 97, 1 ,'select_section',' Select section',' Seleccione la sección ',' Sélectionnez une section',' বিভাগ নির্বাচন করুন '],
		[ 98, 1 ,'generate',' Generate',' Generar ',' produire',' জেনারেট করুন'],
		[ 99, 1 ,'admission ',' Admission ',' Admisión',' Admission ',' স্বীকারোক্তি'],
		[ 100 , 1 ,'class_Sec ',' Class (Sec.)',' Clase (Sec.)',' Classe (Sec.) ',' ক্লাস (সেকেন্ড।)'],
		[ 101 , 1 ,'father',' Father',' Padre ',' Père',' পিতা'],
		[ 102 , 1 ,'date_of_birth ',' Date Of Birth ',' Fecha de nacimiento ',' Date de naissance ',' জন্ম তারিখ'],
		[ 103 , 1 ,'gender',' Gender',' Género',' Le sexe ',' লিঙ্গ '],
		[ 104 , 1 ,'mobile',' Mobile',' Móvil ',' Mobile',' মোবাইল'],
		[ 105 , 1 ,'student_id_card ',' Student ID Card ',' Credencial de estudiante',' Carde didentité détudiant ',' ছাত্র আইডি কার্ড'],
		[ 106 , 1 ,'id_card_title ',' ID Card Title ',' Título de la tarjeta de identificación',' Titre de la carte didentité',' আইডি কার্ড শিরোনাম'],
		[ 107 , 1 ,'number',' Number',' Número',' Nombre',' সংখ্যা'],
		[ 108 , 1 ,'mother',' Mother',' Madre ',' Mère',' মা'],
		[ 109 , 1 ,'blood_group ',' Blood Group ',' Grupo sanguíneo ',' Groupe sanguin',' রক্তের গ্রুপ'],
		[ 110 , 1 ,'id_card ',' ID Card ',' Tarjeta de identificación ',' Carte didentité',' পরিচয় পত্র '],
		[ 111 , 1 ,'generate_id_card',' Generate ID Card',' Generar tarjeta de identificación ',' Générer une carte didentité',' আইডি কার্ড জেনারেট করুন '],
		[ 112 , 1 ,'all ',' All ',' Todos ',' Tout',' সব'],
		[ 113 , 1 ,'relation_with_guardian',' Relation with Guardian',' Relación con Guardian ',' Relation avec le gardien',' গার্ডিয়ান সঙ্গে সম্পর্ক'],
		[ 114 , 1 ,'admin ',' Admin ',' Administración',' Admin ',' অ্যাডমিন'],
		[ 115 , 1 ,'follow_up ',' Follow up ',' Seguir',' Suivre',' অনুসরণ করুন '],
		[ 116 , 1 ,'follow_up_admission_query ',' Follow Up Admission Query ',' Consulta de seguimiento de admisión ',' Requête dadmission de suivi',' ভর্তি পরীক্ষা প্রশ্ন অনুসরণ করুন'],
		[ 117 , 1 ,'response',' Response',' Respuesta ',' Réponse ',' প্রতিক্রিয়া'],
		[ 118 , 1 ,'follow_up_list',' Follow Up List',' Lista de seguimiento',' Liste de suivi',' তালিকা অনুসরণ করুন'],
		[ 119 , 1 ,'query_by',' Query By',' Consulta por',' Requête par ',' দ্বারা প্রশ্ন '],
		[ 120 , 1 ,'delete_follow_up_query',' Delete Follow up query',' Eliminar consulta de seguimiento',' Supprimer la requête de suivi ',' ফলো আপ প্রশ্ন মুছে ফেলুন'],
		[ 121 , 1 ,'certificate_body_len',' Max Character lenght 500',' Longitud máxima de caracteres 500 ',' Longueur maximum 500 caractères ',' সর্বোচ্চ অক্ষর 500 সামান্য'],
		[ 122 , 2 ,'student_information ',' Student Info',' Información del estudiante',' Info étudiant ',' ছাত্র তথ্য'],
		[ 123 , 2 ,'student_admission ',' Student Admission ',' Admisión de estudiantes ',' Admission des étudiants ',' ছাত্র ভর্তি '],
		[ 124 , 2 ,'student_import',' Student Import',' Estudiante de importación ',' Import étudiant ',' ছাত্র আমদানি'],
		[ 125 , 2 ,'import',' Import',' Importar',' Importation ',' আমদানি'],
		[ 126 , 2 ,'personal',' Personal',' Personal',' Personnel ',' ব্যক্তিগত '],
		[ 127 , 2 ,'info',' Info',' Información ',' Info',' তথ্য'],
		[ 128 , 2 ,'roll',' Roll',' Rodar ',' Rouleau ',' রোল' ],
		[ 129 , 2 ,'first ',' First ',' primero ',' Premier ',' প্রথম '],
		[ 130 , 2 ,'last',' Last',' Último',' Dernier ',' গত'],
		[ 131 , 2 ,'religion',' Religion',' Religión',' Religion',' ধর্ম'],
		[ 132 , 2 ,'caste ',' Caste ',' Casta ',' Caste ',' জাত '],
		[ 133 , 2 ,'category',' Category',' Categoría ',' Catégorie ',' বিভাগ '],
		[ 134 , 2 ,'height',' Height',' Altura',' la taille ',' উচ্চতা'],
		[ 135 , 2 ,'Weight',' Weight',' Peso',' Poids ',' ওজন '],
		[ 136 , 2 ,'sibling ',' Sibling ',' Hermano ',' Enfant de mêmes parents ',' সমরূপ '],
		[ 137 , 2 ,'information ',' Information ',' Información ',' Information ',' তথ্য'],
		[ 138 , 2 ,'guardian',' Guardian',' guardián',' Gardien ',' অভিভাবক '],
		[ 139 , 2 ,'& ',' & ',' Y ',' Et',' & '],
		[ 140 , 2 ,'occupation',' Occupation',' Ocupación ',' Occupation',' পেশা'],
		[ 141 , 2 ,'photo ',' Photo ',' Foto',' Photo ',' ছবি '],
		[ 142 , 2 ,'Other ',' Others',' Otros ',' Autres',' অন্যরা'],
		[ 143 , 2 ,'relation_with_guardian',' Relation with Guardian',' Relación con Guardian ',' Relation avec le gardien',' গার্ডিয়ান সঙ্গে সম্পর্ক'],
		[ 144 , 2 ,'current ',' Current ',' Corriente ',' Actuel',' বর্তমান '],
		[ 145 , 2 ,'permanent ',' Permanent ',' Permanente',' Permanent ',' স্থায়ী '],
		[ 146 , 2 ,'route_list',' Route List',' Lista de rutas',' Liste des itinéraires ',' রুট তালিকা'],
		[ 147 , 2 ,'driver',' Driver',' Conductor ',' Chauffeur ',' চালক'],
		[ 148 , 2 ,'room',' Room',' Habitación',' Pièce ',' ঘর'],
		[ 149 , 2 ,'national_iD_number',' National ID Number',' Numero de identificacion nacional ',' numéro national didentité',' জাতীয় আইডি নম্বর '],
		[ 150 , 2 ,'local_Id_Number ',' Local Id Number ',' Número de identificación local',' Numéro didentification local ',' স্থানীয় আইডি নম্বর '],
		[ 151 , 2 ,'bank',' Bank',' Banco ',' Banque',' ব্যাংক'],
		[ 152 , 2 ,'previous_school_details ',' Previous School Details ',' Detalles de la escuela anterior ',' Détails de lécole précédente ',' পূর্ববর্তী স্কুল বিবরণ'],
		[ 153 , 2 ,'additional_notes',' Additional Notes',' Notas adicionales ',' Notes complémentaires ',' অতিরিক্ত নোট'],
		[ 154 , 2 ,'parents_and_guardian_info ',' PARENTS & GUARDIAN INFO ',' INFORMACIÓN PARA LOS PADRES Y TUTORES ',' INFO PARENTS ET GARDIENS',' পিতামাতা এবং গার্ডিয়ান তথ্য'],
		[ 155 , 2 ,'transport_and_dormitory_info',' Transport & Dormitory Info',' Información de transporte y dormitorio',' Informations sur le transport et le dortoir ',' পরিবহন ও ডরমিটার তথ্য '],
		[ 156 , 2 ,'document_info ',' Document Info ',' Información del documento ',' Informations sur le document',' নথি তথ্য'],
		[ 157 , 2 ,'document_01_title ',' Document 01 Title ',' Documento 01 Título ',' Document 01 Titre ',' ডকুমেন্ট ১ শিরোনাম'],
		[ 158 , 2 ,'document_02_title ',' Document 02 Title ',' Documento 02 Titulo ',' Document 02 Titre ',' ডকুমেন্ট ২ শিরোনাম'],
		[ 159 , 2 ,'document_03_title ',' Document 03 Title ',' Título del documento 03 ',' Document 03 Titre ',' ডকুমেন্ট ৩ শিরোনাম'],
		[ 160 , 2 ,'document_04_title ',' Document 04 Title ',' Documento 04 Título ',' Document 04 Titre ',' ডকুমেন্ট ৪ শিরোনাম'],
		[ 161 , 2 ,'student_details ',' Student Details ',' Detalles del estudiante ',' Détails de létudiant ',' ছাত্র বিস্তারিত '],
		[ 162 , 2 ,'search_by_name',' Search By Name',' Buscar por nombre ',' Rechercher par nom',' নাম দ্বারা অনুসন্ধান'],
		[ 163 , 2 ,'search_by_roll_no ',' Search By Roll No ',' Búsqueda por rollo no ',' Recherche par roulement no',' রোল নম্বর দ্বারা অনুসন্ধান করুন '],
		[ 164 , 2 ,'father_name ',' Fathers Name ',' Nombre del Padre',' Le nom du père',' বাবার নাম '],
		[ 165 , 2 ,'student_promote ',' Student Promote ',' Estudiante de promoción ',' Étudiant promouvoir ',' ছাত্র প্রচার'],
		[ 166 , 2 ,'select_current_session',' Select Current Session',' Seleccionar sesión actual ',' Sélectionner la session en cours',' বর্তমান সেশন নির্বাচন করুন'],
		[ 167 , 2 ,'select_current_class',' Select current Class',' Seleccione la clase actual',' Sélectionnez la classe actuelle ',' বর্তমান ক্লাস নির্বাচন করুন '],
		[ 168 , 2 ,'select_current_section',' Select Current section',' Seleccione la sección actual',' Sélectionnez la section actuelle',' বর্তমান বিভাগ নির্বাচন করুন' ],
		[ 169 , 2 ,'promote_student_in_next_session ',' Promote Student In Next Session ',' Promover estudiante en la próxima sesión',' Promouvoir létudiant à la prochaine session',' পরবর্তী সেশনে ছাত্র প্রচার করুন '],
		[ 170 , 2 ,'view_academic_performance ',' View Academic Performance ',' Ver rendimiento académico ',' Voir la performance académique',' একাডেমিক পারফরম্যান্স দেখুন '],
		[ 171 , 2 ,'pass',' Pass',' Pasar ',' Passer',' পাস '],
		[ 172 , 2 ,'fail',' Fail',' Fallar',' Échouer ',' ব্যর্থ'],
		[ 173 , 2 ,'select_promote_session',' Select Promote Session',' Seleccione Promover Sesión',' Sélectionnez la session de promotion',' সেশন প্রচার করুন নির্বাচন করুন'],
		[ 174 , 2 ,'select_promote_class',' Select Promote Class',' Seleccione Promover clase ',' Sélectionnez Promouvoir la classe ',' ক্লাস প্রচার করুন নির্বাচন করুন '],
		[ 175 , 2 ,'the_session_is_required ',' The session is required ',' La sesion es obligatoria',' La session est obligatoire',' অধিবেশন প্রয়োজন হয়'],
		[ 176 , 2 ,'the_class_is_required ',' The class is required ',' La clase es obligatoria ',' Le cours est obligatoire',' ক্লাস প্রয়োজন হয়'],
		[ 177 , 2 ,'the_section_is_required ',' The section is required ',' La sección es obligatoria.',' La section est obligatoire',' বিভাগ প্রয়োজন হয়'],
		[ 178 , 2 ,'select_promote_section',' Select Promote Section',' Seleccione la sección de promoción',' Sélectionnez la section de promotion',' নির্বাচন বিভাগ নির্বাচন করুন'],
		[ 179 , 2 ,'promote ',' Promote ',' Promover',' Promouvoir',' উন্নীত করা'],
		[ 180 , 2 ,'student_attendance',' Student Attendance',' Asistencia de estudiantes ',' Assiduité des étudiants ',' ছাত্র উপস্থিতি'],
		[ 181 , 2 ,'select_class',' Select Class',' Seleccionar clase ',' Sélectionnez une classe ',' ক্লাস নির্বাচন করুন '],
		[ 182 , 2 ,'attendance',' Attendance',' Asistencia',' Présence',' উপস্থিতি'],
		[ 183 , 2 ,'attendance_already_submitted_as_holiday ',' Attendance Already Submitted As Holiday. You Can Edit Record',' Asistencia ya enviada como festivo. Puede editar el registro',' Présence déjà soumise à titre de vacances. Vous pouvez modifier lenregistrement',' উপস্থিতি ইতিমধ্যে ছুটির দিন হিসাবে জমা দেওয়া।আপনি রেকর্ড সম্পাদনা করতে পারেন '],
		[ 184 , 2 ,'attendance_already_submitted',' Attendance Already Submitted You Can Edit Record',' La asistencia ya enviada Puede editar el registro ',' Présence déjà soumise Vous pouvez modifier la fiche ',' উপস্থিতি ইতিমধ্যে জমা আপনি রেকর্ড সম্পাদনা করতে পারেন '],
		[ 185 , 2 ,'mark_holiday',' Mark Holiday',' Mark Holiday',' Mark Holiday',' ছুটির দিন চিহ্নিত করুন'],
		[ 186 , 2 ,'present ',' Present ',' Presente',' Présent ',' বর্তমান '],
		[ 187 , 2 ,'late',' Late',' Tarde ',' En retard ',' বিলম্বে '],
		[ 188 , 2 ,'absent',' Absent',' Ausente ',' Absent',' অনুপস্থিত' ],
		[ 189 , 2 ,'half_day',' Half Day',' Medio día ',' Demi-journée',' অর্ধেক দিন'],
		[ 190 , 2 ,'add_note_here ',' Add Note Here ',' Añadir nota aquí',' Ajouter une note ici',' এখানে নোট যোগ করুন'],
		[ 191 , 2 ,'error ',' Error ',' Error ',' Erreur',' এরর '],
		[ 192 , 2 ,'student_attendance_report ',' Student Attendance Report ',' Informe de asistencia del estudiante',' Rapport de présence des étudiants ',' ছাত্র উপস্থিতি রিপোর্ট'],
		[ 193 , 2 ,'january ',' January ',' enero ',' janvier ',' জানুয়ারী '],
		[ 194 , 2 ,'february',' February',' febrero ',' février ',' ফেব্রুয়ারি '],
		[ 195 , 2 ,'march ',' March ',' marzo ',' Mars',' মার্চ '],
		[ 196 , 2 ,'april ',' April ',' abril ',' avril ',' এপ্রিল'],
		[ 197 , 2 ,'may ',' May ',' Mayo',' Peut',' মে'],
		[ 198 , 2 ,'june',' June',' junio ',' juin',' জুন' ],
		[ 199 , 2 ,'july',' July',' julio ',' juillet ',' জুলাই '],
		[ 200 , 2 ,'august',' August',' agosto',' août',' অগাস্ট'],
		[ 201 , 2 ,'september ',' September ',' septiembre',' septembre ',' সেপ্টেম্বর'],
		[ 202 , 2 ,'october ',' October ',' octubre ',' octobre ',' অক্টোবর '],
		[ 203 , 2 ,'november',' November',' noviembre ',' novembre',' নভেম্বর '],
		[ 204 , 2 ,'december',' December',' diciembre ',' décembre',' ডিসেম্বর'],
		[ 205 , 2 ,'select_month',' Select Month',' Seleccione mes',' Sélectionnez un mois',' মাস নির্বাচন করুন '],
		[ 206 , 2 ,'select_year ',' Select Year ',' Seleccione el año ',' Sélectionnez lannée',' বছর নির্বাচন করুন '],
		[ 207 , 2 ,'student_category',' Student Category',' Categoría de estudiante ',' Catégorie détudiant',' ছাত্র বিভাগ '],
		[ 208 , 2 ,'student_category_list ',' Student Category List ',' Lista de categorías de estudiantes',' Liste des catégories détudiants',' ছাত্র শ্রেণী তালিকা' ],
		[ 209 , 2 ,'student_group ',' Student Group ',' Grupo de estudiantes',' Groupe détudiants',' ছাত্র গ্রুপ '],
		[ 210 , 2 ,'group ',' Group ',' Grupo ',' Groupe',' গ্রুপ '],
		[ 211 , 2 ,'disabled_student',' Disabled Students ',' Estudiantes discapacitados',' Etudiants handicapés',' নিষ্ক্রিয় ছাত্রদের '],
		[ 212 , 2 ,'student_list',' Student List',' Lista de estudiantes',' Liste des étudiants ',' ছাত্র তালিকা'],
		[ 213 , 2 ,'birth_certificate ',' Birth Certificate ',' Certificado de nacimiento ',' Certificat de naissance ',' জন্ম সনদ'],
		[ 214 , 2 ,'student_edit',' Student Edit',' Estudiante Editar ',' Étudiant modifier ',' ছাত্র সম্পাদনা'],
		[ 215 , 2 ,'in',' In',' En',' Dans',' মধ্যে '],
		[ 216 , 2 ,'kg',' KG',' KG',' KG',' কেজি'],
		[ 217 , 2 ,'add_parent',' Add Parent',' Añadir padre',' Ajouter un parent ',' মূল যোগ করুন'],
		[ 218 , 2 ,'update_information',' Update information',' Actualizar información',' Mettre à jour les informations',' হালনাগাদ তথ্য' ],
		[ 219 , 2 ,'siblings',' Siblings',' Hermanos',' Frères et sœurs ',' ভাইবোন'],
		[ 220 , 2 ,'guardian_name ',' Guardians Name ',' Nombre del guardián ',' Nom du gardien',' গার্ডিয়ান এর নাম '],
		[ 221 , 2 ,'guardian_email',' Guardians Email',' Email del guardián',' Email du gardien',' গার্ডিয়ান এর ইমেল'],
		[ 222 , 2 ,'guardian_phone',' Guardians Phone',' Teléfono del guardián ',' Téléphone du gardien',' গার্ডিয়ান ফোন'],
		[ 223 , 2 ,'guardian_occupation ',' Guardian Occupation ',' Ocupación Guardián',' Profession de gardien ',' গার্ডিয়ান পেশা '],
		[ 224 , 2 ,'guardian_address',' Guardian Address',' Dirección del tutor ',' Adresse du gardien',' গার্ডিয়ান ঠিকানা '],
		[ 225 , 2 ,'student_address_info',' Student Address Info',' Información de la dirección del estudiante',' Adresse de l\'étudiant ',' ছাত্র ঠিকানা তথ্য '],
		[ 226 , 2 ,'current_address ',' Current Address ',' Direccion actual',' Adresse actuelle',' বর্তমান ঠিকানা'],
		[ 227 , 2 ,'permanent_address ',' Permanent Address ',' dirección permanente',' Adresse permanente',' স্থায়ী ঠিকানা'],
		[ 228 , 2 ,'vehicle_number',' Vehicle Number',' Número de vehículo',' Numéro de véhicule',' যানবাহন নম্বর' ],
		[ 229 , 2 ,'driver_name ',' Driver Name ',' Nombre del conductor',' Nom du conducteur ',' ড্রাইভার নাম'],
		[ 230 , 2 ,'bank_name ',' Bank Name ',' Nombre del banco',' Nom de banque ',' ব্যাংকের নাম'],
		[ 231 , 2 ,'update_student',' update student',' actualizar estudiante ',' mise à jour de létudiant ',' ছাত্র আপডেট করুন'],
		[ 232 , 2 ,'remove',' Remove',' retirar ',' Retirer ',' অপসারণ'],
		[ 233 , 2 ,'are_you ',' Are you sure to remove siblings?',' ¿Estás seguro de eliminar a los hermanos? ',' Êtes-vous sûr de vouloir supprimer vos frères et soeurs?',' আপনি ভাইবোন অপসারণ নিশ্চিত? '],
		[ 234 , 2 ,'download_sample_file',' Download Sample File',' Descargar archivo de muestra',' Télécharger un exemple de fichier ',' নমুনা ফাইল ডাউনলোড করুন '],
		[ 235 , 3 ,'teacher ',' Teacher ',' Profesor',' Prof',' শিক্ষক'],
		[ 236 , 3 ,'upload_content',' Upload Content',' Subir contenido ',' Télécharger du contenu',' আপলোড কন্টেন্ট'],
		[ 237 , 3 ,'assignment',' Assignment',' Asignación',' Affectation ',' নিয়োগ'],
		[ 238 , 3 ,'content_title ',' Content Title ',' Título del contenido',' Titre du contenu',' বিষয়বস্তু শিরোনাম'],
		[ 239 , 3 ,'study_material',' Study Material',' Material de estudio ',' Matériel détude',' শিক্ষাসামগ্রী '],
		[ 240 , 3 ,'syllabus',' Syllabus',' Silaba',' Programme ',' সিলেবাস '],
		[ 241 , 3 ,'other_download',' Other Downloads ',' Otras descargas ',' Autres téléchargements',' অন্যান্য ডাউনলোড'],
		[ 242 , 3 ,'available_for ',' Available for ',' Disponible para ',' Disponible pour ',' সহজলভ্যের জন্যে '],
		[ 243 , 3 ,'admin ',' Admin ',' Administración',' Admin ',' অ্যাডমিন'],
		[ 244 , 3 ,'available_for_all_classes ',' Available for all classes ',' Disponible para todas las clases. ',' Disponible pour toutes les classes',' সব ক্লাসের জন্য উপলব্ধ'],
		[ 245 , 3 ,'action',' Action',' Acción',' action',' কর্ম'],
		[ 246 , 3 ,'other_downloads_list',' Other Downloads List',' Lista de otras descargas',' Autres téléchargements',' অন্যান্য ডাউনলোড তালিকা '],
		[ 247 , 4 ,'fees_collection ',' Fees Collection ',' Colección de tarifas',' Collection de frais ',' ফি সংগ্রহ '],
		[ 248 , 4 ,'collect_fees',' Collect Fees',' Cobrar honorarios ',' Recueillir les frais',' ফি সংগ্রহ করুন'],
		[ 249 , 4 ,'search_fees_payment ',' Search Fees Payment ',' Pago de tarifas de búsqueda ',' Recherche des frais de paiement ',' অনুসন্ধান ফি প্রদান '],
		[ 250 , 4 ,'search_fees_due ',' Search Fees Due ',' Tarifas de búsqueda vencidas',' Frais de recherche dus',' অনুসন্ধান ফি কারণে'],
		[ 251 , 4 ,'fees_master ',' Fees Master ',' Honorarios maestro',' Frais Maître',' ফি মাস্টার'],
		[ 252 , 4 ,'fees_group',' Fees Group',' Grupo de tarifas',' Groupe de frais ',' ফি গ্রুপ'],
		[ 253 , 4 ,'fees_type ',' Fees Type ',' Tipo de Cuotas',' Type de frais ',' ফি প্রকার '],
		[ 254 , 4 ,'fees_discount ',' Fees Discount ',' Tarifas de descuento',' Remise des frais',' ফি ছাড় '],
		[ 255 , 4 ,'fees_forward',' Fees Carry Forward',' Cuotas de llevar adelante ',' Frais reportés',' ফি ফরওয়ার্ড বহন'],
		[ 256 , 4 ,'payment ',' Payment ',' Pago',' Paiement',' পারিশ্রমিক'],
		[ 257 , 4 ,'payment_ID_Details',' Payment ID Details',' Detalles de ID de pago',' ID de paiement',' পেমেন্ট আইডি বিবরণ'],
		[ 258 , 4 ,'mode',' Mode',' Modo',' Mode',' মোড '],
		[ 259 , 4 ,'amount',' Amount',' Cantidad',' Montant ',' পরিমাণ'],
		[ 260 , 4 ,'discount',' Discount',' Descuento ',' Remise',' ডিসকাউন্ট '],
		[ 261 , 4 ,'fine',' Fine',' Multa ',' Bien',' জরিমানা '],
		[ 262 , 4 ,'fees_due_list ',' Fees Due List ',' Lista de cuotas ',' Frais à payer ',' ফি কারণে তালিকা '],
		[ 263 , 4 ,'due_birth ',' Due Birth ',' Nacimiento debido ',' Naissance due ',' জন্মের কারণে'],
		[ 264 , 4 ,'deposit ',' Deposit ',' Depositar ',' Dépôt ',' আমানত '],
		[ 265 , 4 ,'balance ',' Balance ',' Equilibrar',' Équilibre ',' ভারসাম্য'],
		[ 266 , 4 ,'master',' Master',' Dominar ',' Maîtriser ',' মনিব'],
		[ 267 , 4 ,'assign',' Assign',' Asignar ',' Attribuer ',' দায়িত্ব অর্পণ করা'],
		[ 268 , 4 ,'item',' Item',' ít',' Article ',' পদ'],
		[ 269 , 4 ,'content ',' content ',' contenido ',' contenu ',' সন্তুষ্ট'],
		[ 270 , 4 ,'fees_code ',' Fees Code ',' Código de Cuotas',' Code des frais',' ফি কোড'],
		[ 271 , 4 ,'code',' Code',' Código',' Code',' কোড '],
		[ 272 , 4 ,'once',' Once',' Una vez ',' Une fois que',' একদা'],
		[ 273 , 4 ,'year',' Year',' Año ',' Année ',' বছর '],
		[ 274 , 4 ,'previous_Session_Balance_Fees ',' Previous Session Balance Fees ',' Cuotas de balance de la sesión anterior ',' Frais de solde de la session précédente ',' পূর্ববর্তী অধিবেশন ব্যালেন্স ফি '],
		[ 275 , 4 ,'previous_balance_can_only_update_now. ',' Previous balance already forwarded, you can only update now.',' El saldo anterior ya reenviado, solo se puede actualizar ahora. ',' Le solde précédent ayant déjà été transféré, vous ne pouvez mettre à jour que maintenant. ',' পূর্ববর্তী ভারসাম্য ইতিমধ্যে ফরোয়ার্ড করা হয়েছে, আপনি এখন শুধুমাত্র আপডেট করতে পারেন। '],
		[ 276 , 5 ,'accounts',' Accounts',' Cuentas ',' Comptes ',' অ্যাকাউন্টস '],
		[ 277 , 5 ,'profit',' Profit',' Lucro ',' Profit',' মুনাফা'],
		[ 278 , 5 ,'income',' Income',' Ingresos',' le revenu ',' আয় '],
		[ 279 , 5 ,'expense ',' Expense ',' Gastos',' Frais ',' ব্যয় '],
		[ 280 , 5 ,'chart_of_account',' Chart Of Account',' Plan de cuentas ',' Charte dutilisation',' অ্যাকাউন্ট চার্ট'],
		[ 281 , 5 ,'payment_method',' Payment Method',' Método de pago',' Mode de paiement',' মূল্যপরিশোধ পদ্ধতি'],
		[ 282 , 5 ,'bank_account',' Bank Account',' Cuenta bancaria ',' Compte bancaire ',' ব্যাংক হিসাব'],
		[ 283 , 5 ,'a_c_Head',' A/C Head',' A / C Head',' Tête A / C',' এ-সি হেড'],
		[ 284 , 5 ,'add_expense ',' Add Expense ',' Añadir gastos ',' Ajouter une dépense ',' ব্যয় যোগ করুন'],
		[ 285 , 5 ,'search_income_expense ',' Search Income/Expense ',' Buscar ingresos / gastos',' Recherche revenu / dépense',' অনুসন্ধান আয়-ব্যয় '],
		[ 286 , 5 ,'item_Receive',' Item Receive',' El artículo recibe',' Point recevoir',' আইটেম প্রাপ্তি'],
		[ 287 , 5 ,'income_Head ',' Income Head ',' Jefe de ingresos',' Chef de revenu',' আয় হেড '],
		[ 288 , 5 ,'sells ',' Sells ',' Vende ',' Vend',' বিক্রি'],
		[ 289 , 5 ,'grand_total ',' Grand Total ',' Gran total',' somme finale',' সর্বমোট '],
		[ 290 , 5 ,'expense_head',' Expense Head',' Cabeza de gastos',' Chef de dépenses',' ব্যয় মাথা'],
		[ 291 , 5 ,'purchase',' Purchase',' Compra',' achat ',' ক্রয় '],
		[ 292 , 5 ,'from',' From',' Desde ',' De',' থেকে'],
		[ 293 , 5 ,'head',' Head',' Cabeza',' Tête',' মাথা'],
		[ 294 , 5 ,'method',' Method',' Método',' Méthode ',' পদ্ধতি'],
		[ 295 , 5 ,'account_name',' Account Name',' Nombre de la cuenta ',' Nom du compte ',' হিসাবের নাম '],
		[ 296 , 5 ,'opening_balance ',' Opening Balance ',' Saldo de apertura ',' Solde douverture ',' ব্যালেন্স খোলা'],
		[ 297 , 5 ,'account ',' Account ',' Cuenta',' Compte',' হিসাব '],
		[ 298 , 6 ,'human_resource',' Human resource',' Recursos humanos',' Ressource humaine ',' মানব সম্পদ'],
		[ 299 , 6 ,'staff_directory ',' Staff Directory ',' Directorio de Personal',' Répertoire personnel',' স্টাফ ডিরেক্টরি '],
		[ 300 , 6 ,'staff_attendance',' Staff Attendance',' Asistencia del personal ',' Présence du personnel ',' স্টাফ উপস্থিতি'],
		[ 301 , 6 ,'staff_attendance_report ',' Staff Attendance Report ',' Informe de asistencia del personal',' Rapport de présence du personnel',' স্টাফ উপস্থিতি রিপোর্ট'],
		[ 302 , 6 ,'payroll ',' Payroll ',' Nómina de sueldos ',' Paie',' বেতনের'],
		[ 303 , 6 ,'payroll_report',' Payroll Report',' Informe de nómina ',' Rapport de paie ',' Payroll রিপোর্ট '],
		[ 304 , 6 ,'approve_leave_request ',' Approve Leave Request ',' Aprobar Solicitud de Licencia ',' Approuver la demande de congé ',' ছাড় অনুরোধ অনুমোদন '],
		[ 305 , 6 ,'apply_leave ',' Apply Leave ',' Aplicar licencia',' Appliquer congé ',' আবেদন করুন'],
		[ 306 , 6 ,'leave_type',' Leave type',' Dejar tipo',' Laisser type',' টাইপ করুন '],
		[ 307 , 6 ,'department',' Department',' Departamento',' département ',' বিভাগ '],
		[ 308 , 6 ,'designation ',' Designation ',' Designacion ',' La désignation',' উপাধি '],
		[ 309 , 6 ,'staff_list',' Staff List',' Lista de personal ',' Liste du personnel',' স্টাফ তালিকা'],
		[ 310 , 6 ,'add_staff ',' Add Staff ',' Añadir personal ',' Ajouter du personnel',' স্টাফ যোগ করুন'],
		[ 311 , 6 ,'search_by_staff_id',' Search By Staff Id',' Búsqueda por identificación del personal',' Rechercher par ID de personnel',' স্টাফ আইডি দ্বারা অনুসন্ধান করুন'],
		[ 312 , 6 ,'staff ',' Staff ',' Personal',' Personnel ',' কর্মী '],
		[ 313 , 6 ,'select_role ',' Select Role ',' Seleccionar rol ',' Sélectionnez un rôle',' ভূমিকা নির্বাচন করুন'],
		[ 314 , 6 ,'generate_payroll',' Generate Payroll',' Generar Nómina',' Générer la paie ',' Payroll জেনারেট করুন'],
		[ 315 , 6 ,'generated ',' Generate',' Generar ',' produire',' জেনারেট করুন'],
		[ 316 , 6 ,'paid',' Paid',' Pagado',' Payé',' পেইড'],
		[ 317 , 6 ,'not ',' Not ',' No',' ne pas',' না'],
		[ 318 , 6 ,'proceed_to_pay',' Proceed to Pay',' Proceda a pagar ',' Procéder au paiement',' বেতন দিতে এগিয়ে যান'],
		[ 319 , 6 ,'view_payslip',' View Payslip',' Ver recibo de sueldo',' Voir fiche de paie',' Paylip দেখুন'],
		[ 320 , 6 ,'month ',' Month ',' Mes ',' Mois',' মাস '],
		[ 321 , 6 ,'payslip ',' Payslip ',' Boleta de pago',' Fiche de paie ',' স্লিপে'],
		[ 322 , 6 ,'basic_salary',' Basic Salary',' Salario base',' Salaire de base ',' মূল বেতন'],
		[ 323 , 6 ,'earnings',' Earnings',' Ganancias ',' Gains ',' উপার্জন '],
		[ 324 , 6 ,'deductions',' Deductions',' Deducciones ',' Déductions',' কর্তন '],
		[ 325 , 6 ,'gross_salary',' Gross Salary',' Salario bruto ',' Salaire brut',' মোট বেতন'],
		[ 326 , 6 ,'tax ',' Tax ',' Impuesto',' Impôt ',' কর'],
		[ 327 , 6 ,'net_salary',' Net Salary',' Sueldo neto ',' Salaire net ',' মোট বেতন'],
		[ 328 , 6 ,'to',' To',' A ',' À ',' থেকে'],
		[ 329 , 6 ,'apply_date',' Apply date',' Fecha de aplicación ',' Date dapplication',' তারিখ প্রয়োগ করুন'],
		[ 330 , 6 ,'pending ',' Pending ',' Pendiente ',' en attendant',' মুলতুবী '],
		[ 331 , 6 ,'approved',' Approved',' Aprobado',' Approuvé',' অনুমোদিত'],
		[ 332 , 6 ,'cancelled ',' Cancelled ',' Cancelado ',' Annulé',' বাতিল করা হয়েছে'],
		[ 333 , 6 ,'leave_from',' Leave From',' Dejar de',' Partir de ',' থেকে ত্যাগ'],
		[ 334 , 6 ,'leave_to',' Leave to',' Dejar ',' Laisser à ',' ছেড়ে '],
		[ 335 , 6 ,'reason',' Reason',' Razón ',' Raison',' কারণ'],
		[ 336 , 6 ,'leave ',' Leave ',' Salir ',' Laisser ',' ত্যাগ '],
		[ 337 , 6 ,'type_name ',' Type Name ',' Escribe un nombre ',' Nom du type ',' নাম লিখুন '],
		[ 338 , 6 ,'total_days',' Total Days',' Días totales',' Nombre total de jours ',' মোট দিন '],
		[ 339 , 6 ,'leave_type_list ',' Leave Type List ',' Deja la lista de tipos',' Quitter la liste des types',' টাইপ তালিকা ছেড়ে দিন '],
		[ 340 , 6 ,'departments ',' Departments ',' Departamentos ',' Départements',' বিভাগ '],
		[ 341 , 6 ,'department_name ',' Department Name ',' Nombre de Departamento',' Nom du département',' বিভাগ নাম '],
		[ 342 , 6 ,'designations',' Designations',' Designaciones ',' Désignations',' প্রশিক্ষণে'],
		[ 343 , 6 ,'staffs_payroll',' Staffs Payroll',' Nómina de personal',' Personnel ',' স্টাফ Payroll '],
		[ 344 , 6 ,'staff_no',' Staff No',' Personal No ',' Numéro du personnel ',' স্টাফ নং'],
		[ 345 , 6 ,'date_of_joining ',' Date of Joining ',' Fecha de inscripción',' Date dadhésion ',' যোগদানের তারিখ'],
		[ 346 , 6 ,'value ',' Value ',' Valor ',' Valeur',' মান '],
		[ 347 , 6 ,'payroll_summary ',' Payroll Summary ',' Resumen de nómina ',' Résumé de la paie ',' Payroll সারাংশ'],
		[ 348 , 6 ,'calculate ',' calculate ',' calcular',' calculer',' গণনা করা'],
		[ 349 , 6 ,'earning ',' Earning ',' Ganador ',' Revenus ',' রোজগার'],
		[ 350 , 6 ,'deduction ',' Deduction ',' Deducción ',' Déduction ',' সিদ্ধান্তগ্রহণ'],
		[ 351 , 6 ,'submit',' Submit',' Enviar',' Soumettre ',' জমা দিন '],
		[ 352 , 6 ,'edit_staff',' Edit Staff',' Editar Personal ',' Modifier le personnel ',' স্টাফ সম্পাদনা করুন '],
		[ 353 , 6 ,'basic_info',' Basic Info',' Información básica',' Informations de base',' মৌলিক তথ্য'],
		[ 354 , 6 ,'staff_number',' Staff Number',' Numero de personal',' Numéro du personnel ',' স্টাফ সংখ্যা'],
		[ 355 , 6 ,'emergency_mobile',' Emergency Mobile',' Móvil de emergencia ',' Mobile durgence',' জরুরী মোবাইল'],
		[ 356 , 6 ,'current_address ',' Current Address ',' Direccion actual',' Adresse actuelle',' বর্তমান ঠিকানা'],
		[ 357 , 6 ,'permanent_address ',' Permanent Address ',' dirección permanente',' Adresse permanente',' স্থায়ী ঠিকানা'],
		[ 358 , 6 ,'qualifications',' Qualifications',' Calificaciones',' Qualifications',' যোগ্যতা '],
		[ 359 , 6 ,'experience',' Experience',' Experiencia ',' Expérience',' অভিজ্ঞতা'],
		[ 360 , 6 ,'payroll_details ',' Payroll Details ',' Detalles de la nómina ',' Détails de la paie',' পেপার বিবরণ '],
		[ 361 , 6 ,'epf_no',' EPF NO',' EPF NO',' EPF NO',' ইপিএফ নং'],
		[ 362 , 6 ,'bank_info_details ',' Bank Info Details ',' Detalles de la información del banco',' Informations bancaires',' ব্যাংক তথ্য বিবরণ '],
		[ 363 , 6 ,'bank_account_name ',' Bank Account Name ',' Nombre de la cuenta bancaria',' Nom du compte bancaire',' ব্যাংক হিসাব নাম'],
		[ 364 , 6 ,'branch_name ',' Branch Name ',' Nombre de la rama ',' Nom de la filiale ',' শাখার নাম '],
		[ 365 , 6 ,'social_links_details',' Social Links Details',' Detalles de enlaces sociales',' Liens sociaux Détails ',' সামাজিক লিঙ্ক বিবরণ '],
		[ 366 , 6 ,'facebook_url',' Facebook Url',' Facebook URL',' Ladresse URL de Facebook ',' ফেসবুক ইউআরএল '],
		[ 367 , 6 ,'twitter_url ',' Twitter Url ',' URL de Twitter',' URL de Twitter',' টুইটার ইউআরএল '],
		[ 368 , 6 ,'linkedin_url',' Linkedin Url',' Linkedin url',' URL de Linkedin ',' লিঙ্কডিন ইউআরএল '],
		[ 369 , 6 ,'instragram_url',' Instragram Url',' Url de instagram',' URL Instragram',' ইনস্ট্রগ্রাম ইউআরএল '],
		[ 370 , 6 ,'update_staff',' Update Staff',' Personal de actualización ',' Mettre à jour le personnel',' আপডেট স্টাফ '],
		[ 371 , 7 ,'leave ',' Leave ',' Salir ',' Laisser ',' ত্যাগ '],
		[ 372 , 7 ,'leave_define',' Leave Define',' Dejar definir ',' Quitter Définir ',' Define ছেড়ে দিন'],
		[ 373 , 7 ,'my_remaining_leaves ',' My Remaining Leaves ',' Mis hojas restantes ',' Mes feuilles restantes',' আমার অবশিষ্ট পাতা '],
		[ 374 , 7 ,'remaining_days',' Remaining Days',' Días restantes',' Jours restants',' বাকি দিনগুলো'],
		[ 375 , 7 ,'extra_taken ',' Extra Taken ',' Extra Taken ',' Extra pris',' অতিরিক্ত নেওয়া '],
		[ 376 , 7 ,'total_days',' Total Days',' Días totales',' Nombre total de jours ',' মোট দিন '],
		[ 377 , 7 ,'days',' Days',' Dias',' Journées',' দিন '],
		[ 378 , 8 ,'examination ',' Examination ',' Examen',' Examen',' পরীক্ষা '],
		[ 379 , 8 ,'exam',' Exam',' Examen',' Examen',' পরীক্ষা '],
		[ 380 , 8 ,'add_exam_type ',' Add Exam Type ',' Añadir tipo de examen ',' Ajouter un type dexamen',' পরীক্ষার ধরন যোগ করুন '],
		[ 381 , 8 ,'exam_schedule ',' Exam Schedule ',' Horario del examen',' Calendrier des examens',' পরীক্ষার সময়সূচি '],
		[ 382 , 8 ,'marks_register',' Marks Register',' Registro de marcas',' Registre des marques',' চিহ্ন নিবন্ধন করুন'],
		[ 383 , 8 ,'seat_plan ',' Seat Plan ',' Plan de asiento ',' Plan de siège ',' আসন পরিকল্পনা '],
		[ 384 , 8 ,'exam_attendance ',' Exam Attendance ',' Examen de asistencia',' Présence à lexamen ',' পরীক্ষা উপস্থিতি'],
		[ 385 , 8 ,'marks_grade ',' Marks Grade ',' Nota de calificaciones',' Note de marques ',' মার্ক গ্রেড '],
		[ 386 , 8 ,'send_marks_by_sms ',' Send Marks By Sms ',' Enviar marcas por sms ',' Envoyer des marques par sms ',' এসএমএস দ্বারা চিহ্ন পাঠান '],
		[ 387 , 8 ,'question_group',' Question Group',' Grupo de preguntas',' Groupe de questions ',' প্রশ্ন গ্রুপ'],
		[ 388 , 8 ,'question_bank ',' Question Bank ',' Banco de preguntas',' Banque de questions ',' প্রশ্ন ব্যাংক '],
		[ 389 , 8 ,'online_exam ',' Online Exam ',' Examen en linea ',' Examen en ligne ',' অনলাইন পরীক্ষা'],
		[ 390 , 8 ,'exam_type ',' Exam Type ',' Tipo de examen',' Type dexamen ',' পরীক্ষার ধরন'],
		[ 391 , 8 ,'exam_setup',' Exam Setup',' Configuración del examen',' Configuration de lexamen ',' পরীক্ষা সেটআপ '],
		[ 392 , 8 ,'exam_name ',' Exam Name ',' Nombre del examen ',' Nom de lexamen ',' পরীক্ষার নাম'],
		[ 393 , 8 ,'sl',' Sl',' Sl',' Sl',' ক্রমিক'],
		[ 394 , 8 ,'select_subjects ',' Select Subjects ',' Temas seleccionados ',' Sélectionner des sujets ',' বিষয় নির্বাচন করুন '],
		[ 395 , 8 ,'exam_mark ',' Exam Mark ',' Marca de examen ',' Marque dexamen ',' পরীক্ষার চিহ্ন'],
		[ 396 , 8 ,'add_mark_distributions',' Add Mark Distributions',' Añadir Distribuciones de Marca',' Ajouter des distributions de marques',' মার্ক বিতরণ যোগ করুন'],
		[ 397 , 8 ,'exam_title',' Exam Title',' Título del examen ',' Titre de lexamen ',' পরীক্ষার শিরোনাম'],
		[ 398 , 8 ,'ct_AT_Exam',' Name',' Nombre',' prénom',' নাম '],
		[ 399 , 8 ,'mark_distribution ',' Mark Distribution ',' Distribución de marcas',' Distribution des marques',' মার্ক বিতরণ '],
		[ 400 , 8 ,'subject ',' Subject ',' Tema',' Assujettir',' বিষয় '],
		[ 401 , 8 ,'total_mark',' Total Mark',' Marca total ',' Total Mark',' মোট চিহ্ন '],
		[ 402 , 8 ,'view_status ',' View Status ',' Ver el estado de',' Voir le statut',' অবস্থা দেখুন'],
		[ 403 , 8 ,'copy',' Copy',' Dupdo ',' Copie ',' কপি '],
		[ 404 , 8 ,'add_exam_schedule ',' add Exam Schedule ',' añadir horario de exámenes',' ajouter un calendrier dexamen',' পরীক্ষার সময়সূচী যোগ করুন'],
		[ 405 , 8 ,'exam_list ',' Exam List ',' Lista de exámenes ',' Liste dexamen',' পরীক্ষা তালিকা'],
		[ 406 , 8 ,'marks ',' Marks ',' Marcas',' Des notes ',' চিহ্ন '],
		[ 407 , 8 ,'select_exam ',' Select Exam ',' Seleccionar examen',' Sélectionnez un examen',' পরীক্ষা নির্বাচন করুন '],
		[ 408 , 8 ,'percent ',' Percent ',' Por ciento',' Pour cent ',' শতাংশ '],
		[ 409 , 8 ,'seat_plan_report',' Seat Plan Report',' Informe del plan de asiento ',' Rapport de plan de siège',' আসন পরিকল্পনা রিপোর্ট '],
		[ 410 , 8 ,'assign_students ',' Assign Students ',' Asignar estudiantes ',' Attribuer des étudiants ',' ছাত্র নিয়োগ'],
		[ 411 , 8 ,'start_end_time',' start-end time',' hora de inicio y fin',' heure de début',' শুরু শেষ সময় '],
		[ 412 , 8 ,'total_students',' Total Students',' Total de estudiantes',' Total des étudiants ',' মোট ছাত্র '],
		[ 413 , 8 ,'attendance_create ',' Attendance Create ',' Asistencia Crear',' Présence Créer',' উপস্থিতি তৈরি করুন'],
		[ 414 , 8 ,'grade ',' Grade ',' Grado ',' Qualité ',' শ্রেণী'],
		[ 415 , 8 ,'gpa ',' GPA ',' GPA ',' GPA ',' জিপিএ '],
		[ 416 , 8 ,'percent_from',' Percent From',' Porcentaje de ',' Pour cent de',' থেকে শতাংশ'],
		[ 417 , 8 ,'percent_upto',' Percent Upto',' Por ciento hasta',' Pourcentage jusquà ',' শতাংশ পর্যন্ত '],
		[ 418 , 8 ,'send_marks_via_SMS',' Send Marks Via SMS',' Enviar marcas a través de SMS ',' Envoyer des marques par SMS ',' এসএমএস মাধ্যমে চিহ্ন পাঠান'],
		[ 419 , 8 ,'select_receiver ',' Select Receiver ',' Seleccionar Receptor',' Sélectionnez le destinataire',' রিসিভার নির্বাচন করুন '],
		[ 420 , 8 ,'students',' Students',' Estudiantes ',' Étudiants ',' শিক্ষার্থীরা'],
		[ 421 , 8 ,'select_group',' Select Group',' Selecciona grupo',' Sélectionner un groupe',' গ্রুপ নির্বাচন করুন '],
		[ 422 , 8 ,'question_type ',' Question Type ',' tipo de pregunta',' Type de question',' প্রশ্নের ধরন'],
		[ 423 , 8 ,'multiple_choice ',' Multiple Choice ',' Opción multiple ',' Choix multiple',' বহু নির্বাচনী '],
		[ 424 , 8 ,'true_false',' True False',' Verdadero Falso ',' Vrai faux ',' সত্য মিথ্যা '],
		[ 425 , 8 ,'fill_in_the_blanks',' Fill in the Blanks',' Rellenar los espacios en blanco ',' Remplir les espaces vides ',' শুন্যস্তান পূরণ '],
		[ 426 , 8 ,'question',' Question',' Pregunta',' Question',' প্রশ্ন'],
		[ 427 , 8 ,'number_of_options ',' Number Of Options ',' Número de opciones',' Nombre doptions',' বিকল্প সংখ্যা '],
		[ 428 , 8 ,'create',' Create',' Crear ',' Créer ',' সৃষ্টি'],
		[ 429 , 8 ,'option',' option',' opción',' option',' পছন্দ '],
		[ 430 , 8 ,'TRUE',' TRUE',' CIERTO',' VRAI','সত্য'],
		[ 431 , 8 ,'FALSE ',' FALSE ',' FALSO ',' FAUX',' মিথ্যা'],
		[ 432 , 8 ,'suitable_words',' Suitable Words',' Palabras adecuadas',' Mots convenables',' উপযুক্ত শব্দ'],
		[ 433 , 8 ,'start_time',' Start Time',' Hora de inicio',' Heure de début',' সময় শুরু '],
		[ 434 , 8 ,'end_time',' End time',' Hora de finalización',' Heure de fin',' শেষ সময়'],
		[ 435 , 8 ,'minimum_percentage',' Minimum Percentage',' Porcentaje mínimo ',' Pourcentage minimum ',' নূন্যতম শতাংশ '],
		[ 436 , 8 ,'instruction ',' Instruction ',' Instrucción ',' Instruction ',' নির্দেশ '],
		[ 437 , 8 ,'exam_date ',' Exam Date ',' Fecha de examen ',' Date de lexamen',' পরীক্ষার তারিখ'],
		[ 438 , 8 ,'time',' Time',' Hora',' Temps ',' সময়'],
		[ 439 , 8 ,'published ',' Published ',' Publicado ',' Publié',' প্রকাশিত'],
		[ 440 , 8 ,'manage_question ',' Manage Question ',' Gestionar pregunta',' Gérer la question ',' প্রশ্ন পরিচালনা করুন'],
		[ 441 , 8 ,'published_now ',' Published Now ',' Publicado ahora ',' Publié maintenant ',' এখন প্রকাশিত'],
		[ 442 , 8 ,'view_result ',' View Result ',' Ver resultado ',' Voir résultat ',' ফলাফল দেখুন '],
		[ 443 , 8 ,'monday',' Monday',' lunes ',' Lundi ',' সোমবার'],
		[ 444 , 8 ,'tuesday ',' Tuesday ',' martes',' Mardi ',' মঙ্গলবার'],
		[ 445 , 8 ,'wednesday ',' Wednesday ',' miércoles ',' Mercredi',' বুধবার'],
		[ 446 , 8 ,'thursday',' Thursday',' jueves',' Jeudi ',' বৃহস্পতিবার '],
		[ 447 , 8 ,'friday',' Friday',' viernes ',' Vendredi',' শুক্রবার'],
		[ 448 , 8 ,'Saturday',' Saturday',' sábado',' samedi',' শনিবার'],
		[ 449 , 8 ,'sunday',' Sunday',' domingo ',' dimanche',' রবিবার'],
		[ 450 , 8 ,'room_number ',' Room Number ',' Número de habitación',' Numéro de chambre ',' রুম সংখ্যা'],
		[ 451 , 8 ,'not_scheduled ',' Not Scheduled ',' No programada ',' Non prévu ',' নির্ধারিত না'],
		[ 452 , 8 ,'result_view ',' Result View ',' Vista de resultados ',' Résultat',' ফলাফল দেখুন '],
		[ 453 , 8 ,'total_marks ',' Total Marks ',' Notas totales ',' Total des notes ',' মোট চিহ্ন '],
		[ 454 , 8 ,'obtained_marks',' Obtained Marks',' Marcas obtenidas',' Obtenu Marques',' প্রাপ্ত মার্কস'],
		[ 455 , 8 ,'marking ',' Marking ',' Calificación',' Marquage',' অবস্থানসূচক '],
		[ 456 , 8 ,'view_answer_marking ',' View answer & marking ',' Ver respuesta y marcado ',' Voir la réponse et le marquage',' উত্তর এবং চিহ্নিতকরণ দেখুন'],
		[ 457 , 8 ,'online_exam_question',' Online Exam Question',' Pregunta de examen en línea ',' Question dexamen en ligne',' অনলাইন পরীক্ষা প্রশ্ন '],
		[ 458 , 8 ,'question_list ',' Question List ',' Lista de preguntas',' Liste de questions',' প্রশ্ন তালিকা '],
		[ 459 , 8 ,'questions ',' Questions ',' Preguntas ',' Des questions ',' প্রশ্নাবলি'],
		[ 460 , 8 ,'exam_details',' Exam Details',' Detalles del examen ',' Détails de lexamen ',' পরীক্ষা বিবরণ '],
		[ 461 , 8 ,'passing_percentage',' Passing Percentage',' Pasando el porcentaje ',' Passage Pourcentage ',' শতাংশ পাস '],
		[ 462 , 8 ,'online_active_exams ',' Online Active Exams ',' Exámenes activos en línea ',' Examens actifs en ligne ',' অনলাইন সক্রিয় পরীক্ষা'],
		[ 463 , 8 ,'take_exam ',' Take Exam ',' Tomar examen',' Passer un examen',' পরীক্ষা নিন '],
		[ 464 , 8 ,'classes ',' Classes ',' Las clases',' Des classes ',' ক্লাস '],
		[ 465 , 8 ,'exam_terms',' Exam Terms',' Términos del examen ',' Termes de lexamen',' পরীক্ষার শর্তাবলী '],
		[ 466 , 8 ,'documents ',' documents ',' documentos',' documents ',' কাগজপত্র'],
		[ 467 , 8 ,'timeline',' Timeline',' Línea de tiempo ',' Chronologie ',' সময়রেখা'],
		[ 468 , 8 ,'Parent_Guardian_Details ',' Parent / Guardian Details ',' Detalles de padres / tutores',' Détails sur le parent / tuteur',' পিতামাতা / অভিভাবক বিস্তারিত'],
		[ 469 , 8 ,'full_marks',' Full Marks',' La máxima puntuación',' La totalité des points',' পুরো চিহ্ন'],
		[ 470 , 8 ,'results ',' Results ',' Resultados',' Résultats ',' ফলাফল '],
		[ 471 , 8 ,'visible_to_this_person',' Visible to this person',' Visible para esta persona ',' Visible à cette personne',' এই ব্যক্তির কাছে দৃশ্যমান '],
		[ 472 , 8 ,'',' ',' ',' ',' '],
		[ 473 , 9 ,'academics ',' Academics ',' Académica ',' Les universitaires',' শিক্ষাবিদগণ '],
		[ 474 , 9 ,'class_routine ',' Class Routine ',' Rutina de clase ',' Routine de classe ',' ক্লাস রুটিন '],
		[ 475 , 9 ,'class_routine_create',' Class Routine Create',' Rutina de clase Crear ',' Classe Routine Create ',' ক্লাস রুটিন তৈরি করুন '],
		[ 476 , 9 ,'view_teacher_routine',' View Class Routine(Teacher) ',' Ver la rutina de la clase (profesor)',' Voir la routine de classe (enseignant)',' ক্লাস রুটিন দেখুন (শিক্ষক)'],
		[ 477 , 9 ,'assign_subject',' Assign Subject',' Asignar Asunto',' Attribuer un sujet',' বিষয় বরাদ্দ করুন '],
		[ 478 , 9 ,'assign_subject_create ',' Assign Subject create ',' Asignar Asunto crear',' Assigner le sujet créer ',' বিষয় নির্ধারণ করুন '],
		[ 479 , 9 ,'assign_class_teacher',' Assign Class Teacher',' Asignar profesor de clase ',' Attribuer un enseignant de classe ',' ক্লাস শিক্ষক নিয়োগ '],
		[ 480 , 9 ,'subjects',' Subjects',' Asignaturas ',' Sujets',' বিষয় '],
		[ 481 , 9 ,'class ',' Class ',' Clase ',' Classe',' শ্রেণী'],
		[ 482 , 9 ,'section ',' Section',' Seccion ',' Section',' সেকশনস'],
		[ 483 , 9 ,'class_room',' Class Room',' Salón de clases ',' Salle de cours',' ক্লাস রুম '],
		[ 484 , 9 ,'n_a ',' N/A ',' N / A ',' N / A ',' এন / এ'],
		[ 485 , 9 ,'class_teacher ',' Class Teacher ',' Profesor de la clase',' Professeur de classe',' শ্রেণী শিক্ষক '],
		[ 486 , 9 ,'assign_teacher',' Assign teacher',' Asignar maestro ',' Assigner un enseignant',' শিক্ষক নিয়োগ করুন'],
		[ 487 , 9 ,'subject_name',' Subject Name',' Nombre del tema ',' Nom du sujet',' বিষয় নাম '],
		[ 488 , 9 ,'theory',' Theory',' Teoría',' Théorie ',' তত্ত্ব'],
		[ 489 , 9 ,'practical ',' Practical ',' Práctico',' Pratique',' ব্যবহারিক '],
		[ 490 , 9 ,'subject_code',' Subject Code',' Código del Asunto ',' Code de sujet ',' বিষয় কোড '],
		[ 491 , 9 ,'subject_type',' Subject Type',' Tipo de asunto',' Type de sujet ',' বিষয় প্রকার'],
		[ 492 , 9 ,'capacity',' Capacity',' Capacidad ',' Capacité',' ধারণক্ষমতা'],
		[ 493 , 9 ,'cl_ex_time_setup',' Cl/Ex Time Setup',' Cl / Ex Configuración de hora ',' Configuration de lheure Cl / Ex',' ক্ল / প্রাক্তন সময় সেটআপ '],
		[ 494 , 9 ,'class_exam_time_setup ',' Class & Exam Time Setup ',' Configuración de clase y tiempo de examen ',' Configuration du temps de cours et dexamen ',' ক্লাস এবং পরীক্ষার সময় সেটআপ '],
		[ 495 , 9 ,'class_time',' Class Time',' Hora de clase ',' Le moment daller en classe ',' ক্লাস সময়'],
		[ 496 , 9 ,'time_type ',' Time Type ',' Tipo de tiempo',' Type de temps ',' টাইম টাইপ '],
		[ 497 , 9 ,'exam_time ',' Exam Time ',' Tiempo de examen',' Temps dexamen',' পরীক্ষার সময় '],
		[ 498 , 9 ,'period',' Period',' Período ',' Période ',' কাল '],
		[ 499 , 9 ,'select_time ',' Select Time ',' Seleccione tiempo ',' Sélectionnez lheure',' সময় নির্বাচন করুন'],
		[ 500 , 9 ,'not_assigned_yet',' Not assigned yet',' Aún no asignado ',' Pas encore assigné',' এখনো বরাদ্দ করা হয় নি'],
		[ 501 , 10,'home_work ',' HomeWork',' Deberes ',' Devoirs ',' বাড়ির কাজ'],
		[ 502 , 10,'add_homework',' Add Homework',' Añadir tarea',' Ajouter des devoirs ',' বাড়ির কাজ যোগ করুন '],
		[ 503 , 10,'homework_list ',' Homework List ',' Lista de tareas ',' Liste de devoirs',' হোমওয়ার্ক তালিকা '],
		[ 504 , 10,'evaluation_report ',' Homework Evaluation Report',' Informe de evaluación de tareas ',' Rapport dévaluation des devoirs',' হোমওয়ার্ক মূল্যায়ন রিপোর্ট'],
		[ 505 , 10,'submission',' Submission',' Sumisión',' Soumission',' নমন '],
		[ 506 , 10,'attach_file ',' Attach File ',' Adjuntar archivo',' Pièce jointe',' ফাইল সংযুক্ত'],
		[ 507 , 10,'evaluation',' Evaluation',' Evaluación',' Évaluation',' মূল্যায়ন '],
		[ 508 , 10,'created_by',' Created By',' Creado por',' Créé par',' দ্বারা সৃষ্টি '],
		[ 509 , 10,'complete',' Complete',' Completar ',' Achevée ',' সম্পূর্ণ'],
		[ 510 , 10,'incomplete',' Incomplete',' Incompleto',' Incomplet ',' অসম্পূর্ণ '],
		[ 511 , 11,'communicate ',' Communicate ',' Comunicar ',' Communiquer ',' যোগাযোগ করুন'],
		[ 512 , 11,'notice_board',' Notice Board',' Tablón de anuncios',' Tableau daffichage ',' নোটিসবোর্ড'],
		[ 513 , 11,'send_message',' Send Message',' Enviar mensaje',' Envoyer le message',' বার্তা পাঠান'],
		[ 514 , 11,'send_email',' Send Email / Sms',' Enviar correo electrónico / SMS ',' Envoyer un email / sms',' ইমেল / এসএমএস পাঠান '],
		[ 515 , 11,'email_sms_log ',' Email / Sms Log ',' Email / Sms Log ',' Journal Email / Sms ',' ইমেইল / এসএমএস লগ '],
		[ 516 , 11,'event ',' Event ',' Evento',' un événement',' ঘটনা'],
		[ 517 , 11,'notices ',' Notices ',' Avisos',' Les avis',' নোটিশ '],
		[ 518 , 11,'notice',' Notice',' darse cuenta',' Remarquer ',' বিজ্ঞপ্তি '],
		[ 519 , 11,'publish ',' Publish ',' Publicar',' Publier ',' প্রকাশ করা'],
		[ 520 , 11,'add_notice',' Add Notice',' Añadir aviso',' Ajouter un avis ',' নোটিশ যোগ করুন'],
		[ 521 , 11,'add_a_notice',' Add a Notice',' Añadir un aviso ',' Ajouter un avis ',' একটি নোটিশ যোগ করুন '],
		[ 522 , 11,'publish_on',' Publish On',' Publicar en ',' Publier sur ',' প্রকাশ করুন '],
		[ 523 , 11,'Send_Email_Sms',' Send Email',' Enviar correo electrónico ',' Envoyer un email',' ইমেইল পাঠান '],
		[ 524 , 11,'sms ',' Sms ',' SMS ',' SMS ',' খুদেবার্তা'],
		[ 525 , 11,'individual',' Individual',' Individual',' Individuel',' স্বতন্ত্র '],
		[ 526 , 11,'select_all',' Select All',' Seleccionar todo',' Tout sélectionner ',' সব নির্বাচন করুন'],
		[ 527 , 11,'For_Sending_Email ',' For Sending Email / Sms, It may take some seconds. So please take patience. ',' Para enviar correo electrónico / SMS, puede tardar unos segundos. Así que por favor ten paciencia.',' Pour lenvoi demails / sms, cela peut prendre quelques secondes. Alors sil vous plaît prenez patience.',' ইমেল / এসএমএস পাঠানোর জন্য, এটি কয়েক সেকেন্ড সময় নিতে পারে। তাই ধৈর্য ধরুন। '],
		[ 528 , 11,'send',' Send',' Enviar',' Envoyer ',' পাঠান '],
		[ 529 , 11,'start_date',' Start Date',' Fecha de inicio ',' Date de début ',' শুরুর তারিখ '],
		[ 530 , 11,'to_date ',' To Date ',' Hasta la fecha',' À ce jour ',' এখন পর্যন্ত '],
		[ 531 , 11,'from_date ',' from Date ',' partir de la fecha',' partir de la date ',' তারিখ হইতে'],
		[ 532 , 11,'details ',' Details ',' Detalles',' Détails ',' বিস্তারিত '],
		[ 533 , 11,'notice_date ',' Notice Date ',' Fecha de notificacion ',' Date davis ',' নোটিশ তারিখ '],
		[ 534 , 11,'update_content',' Update content',' Actualizar contenido',' Mettre à jour le contenu',' কন্টেন্ট আপডেট করুন '],
		[ 535 , 12,'library ',' Library ',' Biblioteca',' Bibliothèque',' গ্রন্থাগার'],
		[ 536 , 12,'add_book',' Add Book',' Añadir libro',' Ajouter un livre',' বই যোগ করুন '],
		[ 537 , 12,'book_list ',' Book List ',' Lista de libros ',' Liste de livres ',' বইএর তালিকা '],
		[ 538 , 12,'book_category ',' Book Categories ',' Categorías de libros',' Catégories de livre ',' বই বিভাগ'],
		[ 539 , 12,'library_member',' Add Member',' Añadir miembro',' Ajouter un membre ',' সদস্য যুক্ত করুন'],
		[ 540 , 12,'member_list ',' Issue/Return Book ',' Libro de emisión / devolución ',' Livre démission / retour ',' ইস্যু / রিটার্ন বুক '],
		[ 541 , 12,'all_issued_book ',' All Issued Book ',' Todo el libro publicado ',' Tous les livres publiés ',' সব প্রকাশিত বই'],
		[ 542 , 12,'edit_book ',' Edit Book ',' Editar libro',' Editer le livre ',' বই সম্পাদনা করুন'],
		[ 543 , 12,'book',' Book',' Libro ',' Livre ',' বই'],
		[ 544 , 12,'book_title',' Book Title',' Titulo del libro',' Titre de livre',' বইয়ের শিরোনাম'],
		[ 545 , 12,'select_book_category',' Select Book Category',' Seleccionar categoría de libro',' Sélectionnez une catégorie de livre ',' বই বিভাগ নির্বাচন করুন'],
		[ 546 , 12,'isbn',' ISBN',' ISBN',' ISBN',' আইএসবিএন'],
		[ 547 , 12,'publisher ',' Publisher ',' Editor',' Éditeur ',' প্রকাশক '],
		[ 548 , 12,'author_name ',' Author Name ',' Nombre del autor',' Nom de lauteur ',' লেখকের নাম'],
		[ 549 , 12,'rack',' Rack',' Estante ',' Grille',' তাক '],
		[ 550 , 12,'quantity',' Quantity',' Cantidad',' Quantité',' পরিমাণ'],
		[ 551 , 12,'book_price',' Book Price',' Precio del libro',' Prix ​​du livre ',' বই মূল্য'],
		[ 552 , 12,'price ',' Price ',' Precio',' Prix',' মূল্য '],
		[ 553 , 12,'category_name ',' Category Name ',' nombre de la categoría',' Nom de catégorie',' বিভাগ নাম '],
		[ 554 , 12,'add_member',' Add Member',' Añadir miembro',' Ajouter un membre ',' সদস্য যুক্ত করুন'],
		[ 555 , 12,'member',' Member',' Miembro ',' Membre',' সদস্য '],
		[ 556 , 12,'member_type ',' Member Type ',' Tipo de miembro ',' Type de membre',' সদস্য প্রকার'],
		[ 557 , 12,'select_student',' Select Student',' Seleccionar estudiante',' Sélectionnez étudiant ',' ছাত্র নির্বাচন করুন '],
		[ 558 , 12,'issue_books ',' Issue Books ',' Libros de emisión ',' Livres de questions ',' ইস্যু বই'],
		[ 559 , 12,'full_name ',' Full Name ',' Nombre completo ',' Nom complet ',' পুরো নাম'],
		[ 560 , 12,'issue_return_Book ',' Issue / Return Book ',' Libro de emisión / devolución ',' Livre démission / retour ',' ইস্যু / রিটার্ন বুক '],
		[ 561 , 12,'issued_Book_List',' Issued Book List',' Lista de libros emitidos',' Liste des livres publiés',' ইস্যু করা বই তালিকা '],
		[ 562 , 12,'select_Book_Name',' Select Book Name',' Seleccione el nombre del libro',' Sélectionnez le nom du livre',' বুক নাম নির্বাচন করুন '],
		[ 563 , 12,'search_By_Book_ID ',' Search By Book ID ',' Buscar por ID de libro',' Rechercher par numéro de livre',' বই আইডি দ্বারা অনুসন্ধান করুন '],
		[ 564 , 12,'author',' Author',' Autor ',' Auteur',' লেখক'],
		[ 565 , 12,'library_book_issue',' Library Book Issue',' Número de libro de la biblioteca',' Problème de livre de bibliothèque ',' লাইব্রেরী বই ইস্যু'],
		[ 566 , 12,'staff_name',' Staff Name',' Nombre del personal ',' Nom du personnel',' স্টাফ নাম '],
		[ 567 , 12,'select_book ',' Select Book ',' Seleccionar libro ',' Sélectionnez un livre ',' বই নির্বাচন করুন'],
		[ 568 , 12,'issue_book',' Issue Book',' Libro de temas',' Numéro de livre ',' ইস্যু বই'],
		[ 569 , 12,'issued_book ',' Issued Book ',' Libro publicado ',' Livre publié',' প্রকাশিত বই '],
		[ 570 , 12,'book_number ',' Book Number ',' Número de libro ',' Numéro du livre ',' বই সংখ্যা '],
		[ 571 , 12,'status',' Status',' Estado',' Statut',' অবস্থা'],
		[ 572 , 12,'issue_date',' Issue Date',' Fecha de asunto ',' Date démission ',' প্রদানের তারিখ'],
		[ 573 , 12,'return_this_book',' Are you sure to Return This Book ?',' ¿Seguro que regresas este libro?',' Êtes-vous sûr de retourner ce livre?',' আপনি এই বই ফেরত নিশ্চিত?'],
		[ 574 , 12,'return_date ',' Return Date ',' Fecha de regreso',' Date de retour',' ফিরে তারিখ'],
		[ 575 , 13,'inventory ',' Inventory ',' Inventario',' Inventaire',' জায়'],
		[ 576 , 13,'item_category ',' Item Category ',' Categoría de artículo ',' Catégorie darticle ',' আইটেম বিভাগ '],
		[ 577 , 13,'item_list ',' Item List ',' Lista de articulos',' Liste des articles',' উপকরণ তালিকা'],
		[ 578 , 13,'item_store',' Item Store',' Tienda de articulos ',' Magasin darticles',' আইটেম স্টোর '],
		[ 579 , 13,'supplier',' Supplier',' Proveedor ',' Fournisseur ',' সরবরাহকারী'],
		[ 580 , 13,'item_receive',' Item Receive',' El artículo recibe',' Point recevoir',' আইটেম প্রাপ্তি'],
		[ 581 , 13,'item_receive_list ',' Item Receive List ',' Lista de artículos recibidos',' Item Receive List ',' আইটেম তালিকা প্রাপ্তি '],
		[ 582 , 13,'item_sell ',' Item Sell ',' Venta de artículos',' Article Vendre',' আইটেম বিক্রি'],
		[ 583 , 13,'item_issue',' Item Issue',' Emisión del artículo',' Question darticle',' আইটেম ইস্যু '],
		[ 584 , 13,'select_item_category',' Select Item Category',' Seleccione la categoría del artículo',' Sélectionner une catégorie darticle',' আইটেম বিভাগ নির্বাচন করুন '],
		[ 585 , 13,'selected',' Selected',' Seleccionado',' Choisi',' নির্বাচিত '],
		[ 586 , 13,'total_in_stock',' Total in Stock',' Total en Stock',' Total en stock',' স্টক মোট'],
		[ 587 , 13,'store_name',' Store Name',' Nombre de la tienda ',' Nom du magasin',' দোকানের নাম '],
		[ 588 , 13,'store_number',' Store Number',' Número de tienda',' Numéro de magasin ',' স্টোর সংখ্যা'],
		[ 589 , 13,'company ',' Company ',' Empresa ',' Entreprise',' কোম্পানির '],
		[ 590 , 13,'contact_person_name ',' Contact Person Name ',' Nombre del Contacto ',' nom de contacte dune personne',' যোগাযোগ ব্যক্তির নাম'],
		[ 591 , 13,'contact_person',' Contact Person',' Persona de contacto ',' Contact ',' যোগাযোগ করুন'],
		[ 592 , 13,'receive_details ',' Receive Details ',' Recibir detalles',' Recevoir les détails',' বিস্তারিত পাবেন '],
		[ 593 , 13,'select_supplier ',' Select Supplier ',' Seleccionar Proveedor ',' Sélectionner un fournisseur ',' সরবরাহকারী নির্বাচন করুন'],
		[ 594 , 13,'receive_date',' Receive Date',' Fecha de recepción',' date de réception ',' গ্রহণের তারিখ '],
		[ 595 , 13,'product_name',' Product Name',' nombre del producto ',' Nom du produit',' পণ্যের নাম'],
		[ 596 , 13,'unit_price',' Unit Price',' Precio unitario ',' Prix ​​unitaire ',' একক দাম '],
		[ 597 , 13,'sub_total ',' Sub Total ',' Sub Total ',' Total partiel ',' সাব মোট '],
		[ 598 , 13,'full_paid ',' Full Paid ',' Completo pagado ',' Complet payé',' সম্পূর্ণ পরিশোধিত '],
		[ 599 , 13,'total_paid',' Total Paid',' Total pagado',' Total payé',' মোট দেওয়া'],
		[ 600 , 13,'total_due ',' Total Due ',' Total a pagar ',' Total dû',' মোট বাকি'],
		[ 601 , 13,'receive ',' Receive ',' Recibir ',' Recevoir',' গ্রহণ করা '],
		[ 602 , 13,'new ',' New ',' Nuevo ',' Nouveau ',' নতুন'],
		[ 603 , 13,'total_quantity',' Total Quantity',' Cantidad total',' Quantité totale ',' মোট পরিমাণ'],
		[ 604 , 13,'partial_paid',' Partial Paid',' Parcial pagado',' Partiellement payé',' আংশিক প্রদত্ত '],
		[ 605 , 13,'unpaid',' Unpaid',' No pagado ',' Non payé',' অবৈতনিক '],
		[ 606 , 13,'refund',' Refund',' Reembolso ',' Rembourser',' প্রত্যর্পণ'],
		[ 607 , 13,'buyer ',' Buyer ',' Comprador ',' Acheteur',' ক্রেতা'],
		[ 608 , 13,'issue_item',' Issue Item',' Elemento de emisión ',' Point démission',' সমস্যা আইটেম'],
		[ 609 , 13,'issue_a_item',' Issue a Item',' Emitir un artículo',' Émettre un article',' একটি আইটেম ইস্যু'],
		[ 610 , 13,'user_type ',' User Type ',' Tipo de usuario ',' Type dutilisateur',' ব্যবহারকারীর ধরন'],
		[ 611 , 13,'select_student_for_issue',' Select Student For Issue',' Seleccionar estudiante para su emisión',' Sélectionner un étudiant pour lédition ',' সমস্যা জন্য ছাত্র নির্বাচন করুন '],
		[ 612 , 13,'issue_to',' Issue To',' Emitido a ',' Issue to',' ইস্যু '],
		[ 613 , 13,'issued_item_list',' Issued Item List',' Lista de elementos emitidos ',' Liste darticles publiés',' ইস্যু আইটেম তালিকা'],
		[ 614 , 13,'issued',' Issued',' Emitido ',' Publié',' ইস্যু করা '],
		[ 615 , 13,'returned',' Returned',' Devuelto',' Revenu',' ফেরৎ'],
		[ 616 , 13,'cancel_the_record ',' You are about to cancel the record. This cannot be undone. are you sure?',' Estás a punto de cancelar el registro. Esto no se puede deshacer. ¿Estás seguro?',' Vous êtes sur le point dannuler lenregistrement. Ça ne peut pas être annulé. êtes-vous sûr? ',' আপনি রেকর্ড বাতিল করতে চলেছেন। এটা অসম্পূর্ণ থাকতে পারে না. তুমি কি নিশ্চিত?'],
		[ 617 , 13,'return',' Return',' Regreso ',' Revenir ',' প্রত্যাবর্তন'],
		[ 618 , 13,'purchase_details',' Purchase Details',' Detalles de la compra ',' Les détails dachat ',' ক্রয় বিবরণ '],
		[ 619 , 14,'transport ',' Transport ',' Transporte',' Transport ',' পরিবহন'],
		[ 620 , 14,'routes',' Routes',' Rutas ',' Itinéraires ',' রুট '],
		[ 621 , 14,'vehicle ',' Vehicle ',' Vehículo',' Véhicule',' বাহন'],
		[ 622 , 14,'assign_vehicle',' Assign Vehicle',' Asignar vehículo',' Assigner un véhicule',' যানবাহন বরাদ্দ করুন '],
		[ 623 , 14,'student_transport_report',' Student Transport Report',' Informe de transporte de estudiantes',' Rapport de transport étudiant ',' ছাত্র পরিবহন রিপোর্ট'],
		[ 624 , 14,'transport_route ',' Transport Route ',' Ruta de transporte',' Route de transport',' পরিবহন রুট'],
		[ 625 , 14,'route ',' Route ',' Ruta',' Route ',' রুট '],
		[ 626 , 14,'route_title ',' Route Title ',' Título de la ruta ',' Titre de la route ',' রুট শিরোনাম '],
		[ 627 , 14,'fare',' Fare',' Tarifa',' Tarif ',' ভাড়া '],
		[ 628 , 14,'model ',' Model ',' Modelo',' Modèle',' মডেল'],
		[ 629 , 14,'year_made ',' Year Made ',' Año hecho ',' Année de fabrication',' বছর তৈরি'],
		[ 630 , 14,'select_driver ',' Select Driver ',' Seleccione Driver ',' Sélectionnez le pilote',' ড্রাইভার নির্বাচন করুন'],
		[ 631 , 14,'license ',' License ',' Licencia',' Licence ',' লাইসেন্স'],
		[ 632 , 14,'select_route',' Select Route',' Seleccione Ruta ',' Sélectionnez un itinéraire',' রুট নির্বাচন করুন '],
		[ 633 , 14,'select_vehicle',' Select Vehicle',' Seleccionar vehiculo',' Choisir un véhicule ',' যানবাহন নির্বাচন করুন '],
		[ 634 , 14,'father_phone',' Fathers Phone',' Telefono del padre',' Téléphone du père ',' বাবা ফোন'],
		[ 635 , 14,'mother_name ',' Mothers Name ',' Nombre de la madre',' Le nom de la mère ',' মায়ের নাম'],
		[ 636 , 14,'mother_phone',' Mothers Phone',' Teléfono de la madre',' Téléphone de la mère',' মা এর ফোন '],
		[ 637 , 15,'dormitory ',' Dormitory ',' Dormitorio',' Dortoir ',' ছাত্রাবাস '],
		[ 638 , 15,'dormitory_rooms ',' Dormitory Rooms ',' Dormitorios ',' Dortoirs',' ডরমিটার রুম '],
		[ 639 , 15,'room_type ',' Room Type ',' Tipo de habitación',' Type de chambre ',' ঘরের বিবরণ'],
		[ 640 , 15,'student_dormitory_report',' Student Dormitory Report',' Informe del dormitorio de estudiantes ',' Rapport du dortoir des étudiants',' ছাত্র ডরমিটার রিপোর্ট '],
		[ 641 , 15,'number_of_bed ',' Number Of Bed ',' Numero de cama',' Nombre de lit ',' বিছানা সংখ্যা '],
		[ 642 , 15,'cost_per_bed',' Cost Per Bed',' Costo por cama',' Coût par lit',' বিছানা প্রতি খরচ'],
		[ 643 , 15,'no_of_bed ',' NO. OF BEd',' NO. DE LA CAMA',' NON. DE LIT ',' কোন বেড এর '],
		[ 644 , 15,'dormitory_list',' Dormitory List',' Lista de dormitorios',' Liste des dortoirs',' ডরমিটার তালিকা'],
		[ 645 , 15,'boys',' Boys',' Muchachos ',' Garçons ',' বয়েজ '],
		[ 646 , 15,'girls ',' Girls ',' Chicas',' Filles',' গার্লস'],
		[ 647 , 15,'intake',' Intake',' Consumo ',' Admission ',' ঘেরা জমি'],
		[ 648 , 15,'select_dormitory',' Select Dormitory',' Dormitorio selecto',' Sélectionnez un dortoir ',' ডরমিটার নির্বাচন করুন '],
		[ 649 , 15,'guardian_phone',' Guardians Phone',' Teléfono del guardián ',' Téléphone du gardien',' গার্ডিয়ান ফোন'],
		[ 650 , 16,'reports ',' Reports ',' Informes',' Rapports',' প্রতিবেদন '],
		[ 651 , 16,'student_report',' Student Report',' Informe del estudiante',' Rapport détudiant',' ছাত্র রিপোর্ট '],
		[ 652 , 16,'guardian_report ',' Guardian Reports',' Informes del tutor',' Rapports de gardien ',' গার্ডিয়ান রিপোর্ট'],
		[ 653 , 16,'student_history ',' Student History ',' Historia del estudiante ',' Histoire des étudiants',' ছাত্র ইতিহাস'],
		[ 654 , 16,'student_login_report',' Student Login Report',' Informe de inicio de sesión del estudiante',' Rapport de connexion détudiant ',' ছাত্র লগইন রিপোর্ট'],
		[ 655 , 16,'fees_statement',' Fees Statement',' Declaración de honorarios ',' Relevé des frais',' ফি বিবৃতি '],
		[ 656 , 16,'balance_fees_report ',' Balance Fees Report ',' Informe de comisiones de saldo',' Bilan des frais ',' ব্যালেন্স ফি রিপোর্ট'],
		[ 657 , 16,'transaction_report',' Transaction Report',' Reporte de transacción',' Rapport de transaction',' লেনদেন রিপোর্ট'],
		[ 658 , 16,'class_report',' Class Report',' Informe de clase',' Rapport de classe ',' ক্লাস রিপোর্ট '],
		[ 659 , 16,'merit_list_report ',' Merit List Report ',' Informe de la lista de méritos',' Rapport de liste de mérite',' মেধার তালিকা রিপোর্ট'],
		[ 660 , 16,'online_exam_report',' Online Exam Report',' Informe de examen en línea',' Rapport dexamen en ligne ',' অনলাইন পরীক্ষা রিপোর্ট'],
		[ 661 , 16,'mark_sheet_report ',' Mark Sheet Report ',' Informe de hoja de marcas ',' Rapport de feuille de marque',' মার্ক শীট রিপোর্ট '],
		[ 662 , 16,'tabulation_sheet_report ',' Tabulation Sheet Report ',' Informe de hoja de tabulación ',' Rapport de tabulation ',' ট্যাবলেট শীট রিপোর্ট'],
		[ 663 , 16,'student_fine_report ',' Student Fine Report ',' Informe de estudiante bien',' Rapport de létudiant bien',' ছাত্র ফাইন রিপোর্ট'],
		[ 664 , 16,'user_log',' User Log',' Registro de usuario ',' Journal de lutilisateur',' ব্যবহারকারী লগ'],
		[ 665 , 16,'exam_routine',' Exam Routine',' Rutina de examen',' Routine dexamen',' পরীক্ষা রুটিন '],
		[ 666 , 16,'select_type ',' Select Type ',' Seleccione tipo ',' Sélectionner le genre ',' টাইপ নির্বাচন করুন'],
		[ 667 , 16,'select_gender ',' Select Gender ',' Seleccione género ',' Sélectionnez le sexe',' লিংগ নির্বাচন '],
		[ 668 , 16,'nid ',' NID ',' NID ',' NID ',' জাতীয় পরিচয়পত্র '],
		[ 669 , 16,'Birth_Certificate_Number',' Birth Certificate Number',' Número de Certificado de Nacimiento ',' Numéro Acte de Naissance',' জন্ম শংসাপত্র সংখ্যা'],
		[ 670 , 16,'select_admission_year ',' Select admission Year ',' Seleccione el año de admisión ',' Sélectionnez lannée dadmission',' ভর্তি বছর নির্বাচন করুন '],
		[ 671 , 16,'start_end ',' Start-End ',' Inicio fin',' Début Fin ',' শুরু শেষ'],
		[ 672 , 16,'student_login_info',' Student Login Info',' Información de inicio de sesión del estudiante',' Informations de connexion des étudiants ',' ছাত্র লগইন তথ্য '],
		[ 673 , 16,'login_info_report ',' Login Info Report ',' Informe de información de inicio de sesión',' Login Info Report ',' লগইন তথ্য রিপোর্ট '],
		[ 674 , 16,'username',' Username',' Nombre de usuario ',' Nom dutilisateur ',' ব্যবহারকারীর নাম'],
		[ 675 , 16,'password',' Password',' Contraseña',' Mot de passe',' পাসওয়ার্ড'],
		[ 676 , 16,'parent',' Parent',' Padre ',' Parent',' মাতা'],
		[ 677 , 16,'reset ',' Reset ',' Reiniciar ',' Réinitialiser ',' রিসেট '],
		[ 678 , 16,'due_date',' Due Date',' Fecha de vencimiento',' Date déchéance ',' নির্দিষ্ট তারিখ '],
		[ 679 , 16,'partial ',' Partial ',' Parcial ',' Partiel ',' আংশিক '],
		[ 680 , 16,'discount_of ',' Discount of ',' Descuento de',' Remise de ',' ছাড়'],
		[ 681 , 16,'fees_report ',' Fees Report ',' Informe de tarifas',' Rapport de frais',' ফি রিপোর্ট'],
		[ 682 , 16,'paid_fees ',' Paid Fees ',' Honorarios pagados',' Frais payés ',' পরিশোধিত ফি '],
		[ 683 , 16,'fees_collection_details ',' Fees Collection Details ',' Detalles de la colección',' Frais Collection Détails',' ফি সংগ্রহ বিবরণ '],
		[ 684 , 16,'number_of_student ',' Number Of Student ',' Numero de estudiante',' Nombre détudiant ',' ছাত্র সংখ্যা'],
		[ 685 , 16,'total_subjects_assigned ',' Total Subjects assigned ',' Total de asignaturas asignadas',' Nombre total de sujets assignés ',' মোট বিষয় বরাদ্দ'],
		[ 686 , 16,'collection',' Collection',' Colección ',' Collection',' সংগ্রহ'],
		[ 687 , 16,'due ',' Due ',' Debido',' Dû',' দরুন'],
		[ 688 , 16,'fees_details',' Fees Details',' Detalles de tarifas ',' Détails des frais ',' ফি বিবরণ'],
		[ 689 , 16,'class_routine_report',' Class Routine Report',' Informe de rutina de la clase ',' Rapport de routine de classe',' ক্লাস রুটিন রিপোর্ট '],
		[ 690 , 16,'report',' Report',' Informe ',' rapport ',' প্রতিবেদন '],
		[ 691 , 16,'teacher_class_routine_report',' Teacher Class Routine Report',' Informe de rutina para el maestro ',' Rapport de routine de classe denseignant ',' শিক্ষক ক্লাস রুটিন রিপোর্ট'],
		[ 692 , 16,'select_teacher',' Select Teacher',' Seleccionar profesor',' Sélectionnez un enseignant',' শিক্ষক নির্বাচন করুন'],
		[ 693 , 16,'school_management_system',' School Management System',' Sistema de gestión escolar',' Système de gestion scolaire ',' স্কুল ম্যানেজমেন্ট সিস্টেম'],
		[ 694 , 16,'united_states_of_america',' House 25, Road 27, Block B, 54th Floor, New York, United States of America',' House 25, Road 27, Block B, 54th Floor, Nueva York, Estados Unidos de América ',' Maison 25, route 27, bloc B, 54ème étage, New York, États-Unis dAmérique ',' হাউস ২5, রোড 27, ব্লক বি, 54 তলা, নিউ ইয়র্ক, আমেরিকা যুক্তরাষ্ট্র'],
		[ 695 , 16,'order_of_merit_list ',' Order of merit list ',' Lista de orden de mérito',' Ordre de mérite ',' মেধার তালিকা আদেশ '],
		[ 696 , 16,'position',' Position',' Posición',' Position',' অবস্থান '],
		[ 697 , 16,'average ',' Average ',' Promedio',' Moyenne ',' গড় '],
		[ 698 , 16,'obtained_marks',' Obtained Marks',' Marcas obtenidas',' Obtenu Marques',' প্রাপ্ত মার্কস'],
		[ 699 , 16,'top_obtained_mark ',' Top Obtained Mark ',' Mejor marca obtenida',' Top obtenu la marque',' শীর্ষ প্রাপ্ত মার্ক '],
		[ 700 , 16,'student_terminal_report ',' Student Terminal Report ',' Informe de terminal de estudiante ',' Rapport de fin détude',' ছাত্র টার্মিনাল রিপোর্ট '],
		[ 701 , 16,'progress_card_report',' Progress card report',' Informe de progreso ',' Rapport de carte de progression ',' অগ্রগতি কার্ড রিপোর্ট '],
		[ 702 , 16,'position_in_class ',' Position in Class ',' Posición en clase ',' Position en classe',' ক্লাস অবস্থান '],
		[ 703 , 16,'class_test',' Class Test',' Prueba de clase ',' Test de classe',' ক্লাস টেস্ট '],
		[ 704 , 16,'remarks ',' Remarks ',' Observaciones ',' Remarques ',' মন্তব্য '],
		[ 705 , 16,'user',' User',' Usuario ',' Utilisateur ',' ব্যবহারকারী '],
		[ 706 , 16,'ip',' IP',' IP',' IP',' আইপি'],
		[ 707 , 16,'login_time',' Login Time',' Hora de inicio de sesión',' Heure de connexion',' লগইন সময় '],
		[ 708 , 16,'user_agent',' User Agent',' Agente de usuario ',' Agent utilisateur ',' ব্যবহারিক দূত '],
		[ 709 , 17,'system_settings ',' System Settings ',' Ajustes del sistema ',' Les paramètres du système ',' পদ্ধতি নির্ধারণ '],
		[ 710 , 17,'general_settings',' General Settings',' Configuración general ',' réglages généraux ',' সাধারণ সেটিংস '],
		[ 711 , 17,'email_settings',' Email Settings',' Ajustes del correo electrónico',' Paramètres de messagerie',' ইমেল সেটিংস '],
		[ 712 , 17,'payment_method_settings ',' Payment Method Settings ',' Configuración del método de pago',' Méthode de paiement ',' পেমেন্ট পদ্ধতি সেটিংস '],
		[ 713 , 17,'role',' Role',' Papel ',' Rôle',' ভূমিকা'],
		[ 714 , 17,'base_group',' Base Group',' Grupo base',' Groupe de base',' বেস গ্রুপ '],
		[ 715 , 17,'base_setup',' Base Setup',' Configuración de la base',' Configuration de base ',' বেস সেটআপ '],
		[ 716 , 17,'academic_year ',' Academic Year ',' Año académico ',' Année académique',' শিক্ষাবর্ষ'],
		[ 717 , 17,'session ',' Session ',' Sesión',' Session ',' সেশন'],
		[ 718 , 17,'holiday ',' Holiday ',' Vacaciones',' Vacances',' ছুটির দিন '],
		[ 719 , 17,'sms_settings',' Sms Settings',' Configuración de SMS',' Paramètres Sms',' এসএমএস সেটিংস '],
		[ 720 , 17,'language_settings ',' Language Settings ',' Configuraciones de idioma ',' Paramètres de langue',' ভাষা ব্যাবস্থা'],
		[ 721 , 17,'backup_settings ',' Backup',' Apoyo ',' Sauvegarde',' ব্যাকআপ '],
		[ 722 , 17,'select_language ',' Select Language ',' Seleccione el idioma',' Choisir la langue ',' ভাষা নির্বাচন কর'],
		[ 723 , 17,'native',' Native',' Nativo',' Originaire de ',' স্থানীয়'],
		[ 724 , 17,'universal ',' Universal ',' Universal ',' Universel ',' সার্বজনীন '],
		[ 725 , 17,'make_default',' Make Default',' Hacer por defecto ',' Faire défaut',' ডিফল্ট করা'],
		[ 726 , 17,'setup ',' Setup ',' Preparar',' Installer ',' সেটআপ '],
		[ 727 , 17,'change_logo ',' Change Logo ',' Cambiar Logo',' Changer le logo ',' লোগো পরিবর্তন করুন'],
		[ 728 , 17,'change_fav',' Change Favicon',' Cambiar Favicon ',' Changer de favicon',' পরিবর্তন ফেভিকন '],
		[ 729 , 17,'upload',' Upload',' Subir ',' Télécharger ',' আপলোড '],
		[ 730 , 17,'school_name ',' School Name ',' Nombre de la escuela',' Nom de lécole',' স্কুল নাম '],
		[ 731 , 17,'school_code ',' School Code ',' Código escolar',' Code détablissement',' স্কুল কোড '],
		[ 732 , 17,'language',' Language',' Idioma',' La langue ',' ভাষা'],
		[ 733 , 17,'date_format ',' Date Format ',' Formato de fecha',' Format de date',' তারিখ বিন্যাস '],
		[ 734 , 17,'currency',' Currency',' Moneda',' Devise',' মুদ্রা'],
		[ 735 , 17,'symbol',' Symbol',' Símbolo ',' symbole ',' প্রতীক'],
		[ 736 , 17,'sand',' Sand',' Arena ',' Le sable',' বালি'],
		[ 737 , 17,'smtp',' SMTP',' SMTP',' SMTP',' SMTP এর '],
		[ 738 , 17,'from_name ',' From Name ',' De Nombre ',' De nom',' নাম থেকে'],
		[ 739 , 17,'from_email',' From Email',' Desde el e-mail ',' De lemail',' ইমেইল থেকে'],
		[ 740 , 17,'server',' Server',' Servidor',' Serveur ',' সার্ভার '],
		[ 741 , 17,'port',' Port',' Puerto',' Port',' বন্দর '],
		[ 742 , 17,'security',' Security',' Seguridad ',' Sécurité',' নিরাপত্তা '],
		[ 743 , 17,'select_a_payment_gateway',' Select a Payment Gateway',' Seleccione una pasarela de pago ',' Sélectionnez une passerelle de paiement ',' একটি পেমেন্ট গেটওয়ে নির্বাচন করুন'],
		[ 744 , 17,'checked ',' Checked ',' Comprobado',' Vérifié ',' সংযত'],
		[ 745 , 17,'paypal',' Paypal',' Paypal',' Pay Pal ',' পেপ্যাল '],
		[ 746 , 17,'stripe',' Stripe',' Raya',' Bande ',' ডোরা'],
		[ 747 , 17,'payUMoney ',' PayUMoney ',' PayUMoney ',' PayUMoney ',' PayUMoney '],
		[ 748 , 17,'signature ',' Signature ',' Firma ',' Signature ',' স্বাক্ষর'],
		[ 749 , 17,'client_id ',' Client ID ',' Identificación del cliente',' identité du client',' ক্লায়েন্ট আইডি '],
		[ 750 , 17,'secret_id ',' Secret ID ',' ID secreta',' ID secret ',' গোপন আইডি '],
		[ 751 , 17,'stripe_api_secret_key ',' Stripe API Secret Key ',' Stripe API Secret Key ',' Clé secrète de lAPI de bande ',' স্ট্রিপ এপিআই গোপন কী '],
		[ 752 , 17,'stripe_publisher_key',' Stripe Publishable Key',' Stripe Publishable Key',' Raie Clé Publiable',' দাগ প্রকাশযোগ্য কী'],
		[ 753 , 17,'pay_u_money_key ',' PayU Money Key',' PayU Money Key',' Clé PayU Money',' PayU টাকা কী'],
		[ 754 , 17,'pay_u_money_salt',' PayU Money Salt ',' PayU Money Salt ',' PayU Money Salt ',' PayU টাকা লবণ '],
		[ 755 , 17,'role_permission ',' Role Permission ',' Permiso de rol',' Permission de rôle',' ভূমিকা অনুমতি '],
		[ 756 , 17,'assign_permission ',' Assign Permission ',' Asignar permiso ',' Attribuer une autorisation',' অনুমতি বরাদ্দ করুন'],
		[ 757 , 17,'label ',' Label ',' Etiqueta',' Étiquette ',' লেবেল '],
		[ 758 , 17,'base',' Base',' Base',' Base',' ভিত্তি'],
		[ 759 , 17,'year_title',' Year Title',' Título del año',' Titre de lannée',' বছর শিরোনাম '],
		[ 760 , 17,'starting_date ',' Starting Date ',' Fecha de inicio ',' Date de début ',' শুরু তারিখ'],
		[ 761 , 17,'ending_date ',' Ending Date ',' Fecha de finalización ',' Fin ',' শেষ তারিখ '],
		[ 762 , 17,'select_a_SMS_service',' Select a SMS Service',' Seleccione un servicio de SMS ',' Sélectionnez un service SMS ',' একটি এসএমএস সেবা নির্বাচন করুন'],
		[ 763 , 17,'clickatell',' Clickatell',' Clickatell',' Clickatell',' Clickatell'],
		[ 764 , 17,'settings',' Settings',' Ajustes ',' Réglages',' সেটিংস'],
		[ 765 , 17,'twilio',' Twilio',' Twilio',' Twilio',' Twilio'],
		[ 766 , 17,'api ',' API ',' API ',' API ',' এপিআই '],
		[ 767 , 17,'sid ',' SID ',' SID ',' SID ',' জন্য SId'],
		[ 768 , 17,'authentication',' Authentication',' Autenticación ',' Authentification',' প্রমাণীকরণ'],
		[ 769 , 17,'token ',' Token ',' Simbólico ',' Jeton ',' টোকেন '],
		[ 770 , 17,'registered_phone_number ',' Registered Phone Number ',' Número de teléfono registrado ',' Numéro de téléphone enregistré',' নিবন্ধিত ফোন নম্বর'],
		[ 771 , 17,'authentication_key_SId',' Authentication Key SId',' Clave de autenticación SId',' Clé dauthentification SId',' প্রমাণীকরণ কী এসআইডি'],
		[ 772 , 17,'sender',' Sender',' Remitente ',' Expéditeur',' প্রেরকের'],
		[ 773 , 17,'country_code',' Country Code',' Código de país',' Code postal ',' কান্ট্রি কোড'],
		[ 774 , 17,'select_serial ',' Select serial ',' Seleccione serial ',' Sélectionnez série',' সিরিয়াল নির্বাচন করুন'],
		[ 775 , 17,'day_list',' Day list',' Lista de días ',' Liste de jour ',' দিন তালিকা'],
		[ 776 , 17,'serial',' Serial',' De serie',' En série',' ক্রমিক'],
		[ 777 , 17,'upload_from_local_directory ',' Upload From Local Directory ',' Subir desde el directorio local ',' Télécharger depuis le répertoire local',' স্থানীয় ডিরেক্টরি থেকে আপলোড করুন'],
		[ 778 , 17,'file',' File',' Expediente',' Fichier ',' ফাইল'],
		[ 779 , 17,'cron_secret_key ',' Cron Secret Key ',' Clave secreta de Cron ',' Cron Secret Key ',' ক্রন সিক্রেট কী '],
		[ 780 , 17,'generate_key',' Generate key',' Generar clave ',' Générer une clé ',' কী জেনারেট করুন '],
		[ 781 , 17,'database_backup_list',' Database Backup List',' Lista de respaldo de la base de datos ',' Liste de sauvegarde de la base de données ',' ডাটাবেস ব্যাকআপ তালিকা'],
		[ 782 , 17,'backup',' Backup',' Apoyo ',' Sauvegarde',' ব্যাকআপ '],
		[ 783 , 17,'created_date_time ',' Created Date Time ',' Fecha de creación ',' Date de création heure',' তৈরি তারিখ সময় '],
		[ 784 , 17,'backup_files',' Backup Files',' Archivos de respaldo',' Fichiers de sauvegarde',' ব্যাকআপ ফাইল'],
		[ 785 , 17,'weekend ',' Weekend ',' Fin de semana ',' Weekend ',' সপ্তাহান্তিক কাল'],
		[ 786 , 17,'restore ',' Restore ',' Restaurar ',' Restaurer ',' প্রত্যর্পণ করা'],
		[ 787 , 17,'default ',' Default ',' Defecto ',' Défaut',' ডিফল্ট'],
		[ 788 , 17,'module',' Module',' Módulo',' Module',' মডিউল '],
		[ 789 , 17,'module_link ',' Module Link ',' Enlace del módulo ',' Lien de module',' মডিউল লিঙ্ক '],
		[ 790 , 17,'permission',' Permission',' Permiso ',' Autorisation',' অনুমতি'],
		[ 791 , 17,'site_title',' Site Title',' Título del sitio',' Titre du site ',' সাইট শিরোনাম'],
		[ 792 , 17,'select_session',' Select Session',' Seleccionar sesion',' Sélectionnez une session',' সেশন নির্বাচন করুন'],
		[ 793 , 17,'select_date_format',' Select Date Format',' Seleccione el formato de fecha',' Sélectionnez le format de date',' তারিখ ফরম্যাট নির্বাচন করুন '],
		[ 794 , 17,'select_currency ',' Select Currency ',' Seleccione el tipo de moneda',' Sélectionnez la devise',' কারেন্সি নির্বাচন করুন'],
		[ 795 , 17,'currency_symbol ',' Currency Symbol ',' Símbolo de moneda ',' Symbole de la monnaie ',' মুদ্রা চিহ্ন'],
		[ 796 , 17,'school_address',' School Address',' Dirección de Escuela',' Adresse de lécole',' স্কুল ঠিকানা'],
		[ 797 , 17,'update_language ',' Update Language ',' Actualizar idioma ',' Mise à jour de la langue',' ভাষা আপডেট করুন '],
		[ 798 , 17,'language_setup',' Language Setup',' Configuración de idioma ',' Configuration de la langue',' ভাষা সেটআপ'],
		[ 799 , 18,'front_end_settings',' Front End Settings',' Configuraciones frontales ',' Paramètres frontaux ',' ফ্রন্ট শেষ সেটিংস '],
		[ 800 , 18,'add_news',' Add News',' Añadir noticias ',' Ajouter des nouvelles ',' সংবাদ যোগ করুন'],
		[ 801 , 18,'news',' News',' Noticias',' Nouvelles ',' খবর '],
		[ 802 , 18,'news_list ',' News List ',' Lista de noticias ',' Liste de nouvelles',' সংবাদ তালিকা'],
		[ 803 , 18,'image ',' Image ',' Imagen',' Image ',' ভাবমূর্তি '],
		[ 804 , 18,'publication_date',' Publication Date',' Fecha de publicación',' Date de publication ',' প্রকাশনার তারিখ '],
		[ 805 , 18,'add_testimonial ',' Add Testimonial ',' Añadir Testimonial',' Ajouter un témoignage ',' প্রশংসাপত্র যোগ করুন'],
		[ 806 , 18,'testimonial ',' Testimonial ',' Testimonial ',' Témoignage',' এজাহারনামা'],
		[ 807 , 18,'institution_name',' Institution Name',' Nombre de la Institución',' nom de linstitution',' প্রতিষ্ঠানের নাম'],
		[ 808 , 18,'location',' Location',' Ubicación ',' Emplacement ',' অবস্থান '],
		[ 809 , 18,'front_settings',' Front Settings',' Ajustes frontales ',' Paramètres avant',' ফ্রন্ট সেটিংস '],
		[ 810 , 19,'my_profile',' My Profile',' Mi perfil ',' Mon profil',' আমার প্রোফাইল '],
		[ 811 , 19,'fees',' Fees',' Matrícula ',' Honoraires',' ফি'],
		[ 812 , 19,'pay_fees',' Pay Fees',' Cuotas de pago',' Payer les frais ',' ফি পরিশোধ '],
		[ 813 , 19,'download_center ',' Download Center ',' Centro de descargas ',' centre de téléchargement',' ডাউনলোড কেন্দ্র '],
		[ 814 , 19,'student_study_material',' Study Materials ',' Materiales de estudio ',' Matériel détudes ',' স্টাডি সামগ্রী'],
		[ 815 , 19,'examinations',' Examinations',' Exámenes',' Examens ',' পরীক্ষায় '],
		[ 816 , 19,'result',' result',' resultado ',' résultat',' ফল'],
		[ 817 , 19,'active_exams',' Active Exams',' Exámenes activos',' Examens actifs',' সক্রিয় পরীক্ষা '],
		[ 818 , 19,'book_issue',' Book issued ',' Libro emitido ',' Livre publié',' বই জারি '],
		[ 819 , 19,'my_children ',' My Children ',' Mis hijos ',' Mes enfants ',' আমার শিশু '],
		[ 820 , 19,'exam_result ',' Exam Result ',' Resultado del examen',' Résultat déxamen ',' পরীক্ষার ফলাফল'],
		[ 821 , 19,'teacher_list',' Teacher list',' Lista de profesores ',' Liste des enseignants ',' শিক্ষক তালিকা '],
		[ 822 , 19,'inserted_message',' Operation Successfully ',' Insertado con éxito ',' Inséré avec succès',' সফলভাবে সন্নিবেশ করানো হয়েছে '],
		[ 823 , 19,'updated_message ',' Updated Successfully',' Actualizado exitosamente',' Mis à jour avec succés',' সফলভাবে আপডেট করা হয়েছে'],
		[ 824 , 19,'deleted_message ',' Deleted Successfully',' Borrado exitosamente',' Supprimé avec succès',' সফলভাবে মুছে ফেলা হয়েছে'],
		[ 825 , 19,'inactive_message',' Inactivated Successfully',' Inactivado con éxito',' Inactivé avec succès',' সফলভাবে নিষ্ক্রিয়'],
		[ 826 , 19,'active_message',' Activated Successfully',' Activado con éxito',' Activé avec succès',' সফলভাবে সক্রিয় '],
		[ 827 , 19,'backup_message',' Backup Successfully ',' Copia de seguridad con éxito',' Sauvegarde réussie',' ব্যাকআপ সফলভাবে '],
		[ 828 , 19,'restore_message ',' Restore Successfully',' Restaurar con éxito ',' Restaurer avec succès ',' সফলভাবে পুনরুদ্ধার করুন '],
		[ 829 , 19,'not_found_message ',' Ops! Data not Found ',' Ops! Datos no encontrados ',' Ops! Données non trouvées ',' অপস! তথ্য পাওয়া যায়নি '],
		[ 830 , 19,'error_message ',' Ops! Something went wrong, please try again ',' Ops! Algo salió mal. Por favor, vuelva a intentarlo ',' Ops! Une erreur sest produite. Veuillez réessayer',' অপস! কিছু ভুল হয়েছে আবার চেষ্টা করুন '],
		[ 831 , 19,'front_cms ',' Front cms ',' Frente cms',' Cms avant ',' ফ্রন্ট সিএমএস '],
		[ 832 , 19,'update_system ',' Update System ',' Sistema de actualización',' Système de mise à jour',' আপডেট সিস্টেম '],
		[ 833 , 19,'System_Status ',' System Status ',' Estado del sistema',' État du système ',' সিস্টেমের অবস্থা'],
		[ 834 , 19,'Upgrade ',' Upgrade ',' Mejorar ',' Améliorer ',' আপগ্রেড '],
		[ 835 , 19,'Version ',' Version ',' Versión ',' Version ',' সংস্করণ '],
		[ 836 , 19,'Existing',' Existing',' Existente ',' Existant',' বর্তমান '],
		[ 837 , 19,'Available ',' Available ',' Disponible',' Disponible',' সহজলভ্য '],
		[ 838 , 19,'Alert ',' Alert ',' Alerta',' Alerte',' সতর্ক '],
		[ 839 , 19,'New_Features',' New Features',' Nuevas características',' Nouvelles fonctionnalités ',' নতুন বৈশিষ্ট'],
		[ 840 , 19,'copyright_text',' Copyright Text',' Texto de copyright',' Texte de copyright',' কপিরাইট টেক্সট'],
		[ 841 , 20,'point1',' Your CSV data should be in the format download file. The first line of your CSV file should be the column headers as in the table example. Also make sure that your file is UTF-8 to avoid unnecessary encoding problems. ',' Sus datos CSV deben estar en el archivo de descarga de formato. La primera línea de su archivo CSV debe ser los encabezados de columna como en el ejemplo de la tabla. También asegúrese de que su archivo sea UTF-8 para evitar problemas de codificación innecesarios.',' Vos données CSV doivent être dans le fichier de téléchargement au format. La première ligne de votre fichier CSV doit correspondre aux en-têtes de colonne, comme dans lexemple de tableau. Assurez-vous également que votre fichier est au format UTF-8 afin déviter des problèmes de codage inutiles. ',' আপনার CSV ডেটা ফরম্যাট ডাউনলোড ফাইলে থাকা উচিত। আপনার CSV ফাইলের প্রথম লাইন টেবিল উদাহরণের মতো কলাম শিরোনাম হওয়া উচিত। এছাড়াও আপনার ফাইলটি অপ্রয়োজনীয় এনকোডিং সমস্যাগুলি এড়ানোর জন্য UTF-8 নিশ্চিত করুন। '],

		[ 842 , 20,'point2',' If the column you are trying to import is date make sure that is formatted in format Y-m-d (2018-06-06).',' Si la columna que está intentando importar es fecha, asegúrese de que esté formateada en el formato Y-m-d (2018-06-06). ',' Si la colonne que vous tentez dimporter est datée, assurez-vous quelle est formatée au format Y-m-d (2018-06-06). ',' আপনি যে কলামটি আমদানি করার চেষ্টা করছেন তা তারিখটি Y-m-d (2018-06-06) বিন্যাসে ফর্ম্যাট করা হয়েছে তা নিশ্চিত করার তারিখ। '],
		[ 843 , 20,'point3',' Duplicate "Roll Number" (unique in section) rows will not be imported. Roll No used or not you can get from student report page search on class & section ',' Las filas duplicadas de "Número de rollo" (único en la sección) no se importarán. Rollo No se utiliza o no se puede obtener de la página de informe del alumno en clase y sección ',' Les lignes en double "Numéro de rouleau" (uniques dans la section) ne seront pas importées. Pas de recherche doccasion ou non, vous pouvez obtenir une recherche de page de rapport d’étudiant dans la classe et la section',' সদৃশ "রোল নম্বর" (বিভাগে অনন্য) সারি আমদানি করা হবে না। রোল নম্বর ব্যবহার করা হয়নি অথবা আপনি শ্রেণী এবং বিভাগে ছাত্র প্রতিবেদন পৃষ্ঠা অনুসন্ধান থেকে পেতে পারেন না '],
		[ 844 , 20,'point4',' Duplicate "Guardian email & Guardian Phone" rows will not be imported. Guardian email & Guardian Phone used or not you can get from student report page search on class & section ',' No se importarán filas duplicadas de "Guardian email & Guardian Phone". El correo electrónico de Guardian & Guardian Phone utilizado o no se puede obtener de la página de informe del alumno en la clase y sección ',' Les lignes dupliquées "Email et téléphone Guardian" ne seront pas importées. Guardian email & Guardian Phone utilisé ou non, vous pouvez obtenir une recherche dans la page de rapport de létudiant sur la classe et la section',' সদৃশ গার্ডিয়ান ইমেল ও গার্ডিয়ান ফোন সারি আমদানি করা হবে না। গার্ডিয়ান ইমেল এবং গার্ডিয়ান ফোন ব্যবহার করা হয়েছে অথবা আপনি বিভাগ এবং বিভাগে ছাত্র প্রতিবেদন পৃষ্ঠা অনুসন্ধান থেকে পেতে পারেন না'],
		[ 845 , 20,'point5',' For student Session use Id',' Para el estudiante Sesión use Id',' Pour les étudiants "Session", utilisez lidentifiant',' ছাত্র "সেশন" জন্য আইডি ব্যবহার করুন '],
		[ 846 , 20,'point6',' For student "Gender" use ID ',' Para el estudiante "Género" usar ID ',' Pour létudiant "Sexe", utilisez lidentifiant',' শিক্ষার্থী জন্য "লিঙ্গ" আইডি ব্যবহার করুন '],
		[ 847 , 20,'point7',' For student "Blood Group" use Id',' Para el estudiante "Grupo de sangre" use ID ',' Pour les étudiants Groupe sanguin, utilisez lId',' ছাত্রদের জন্য রক্ত গ্রুপ আইডি ব্যবহার করুন'],
		[ 848 , 20,'point8',' For student "Religion" use ID ',' Para el estudiante "Religión" usar identificación ',' Pour les étudiants Religion, utilisez votre identifiant ',' ছাত্রের জন্য ধর্ম আইডি ব্যবহার করুন '],
		[ 849 , 20,'point9',' For student "Guardian Relation" use capital O for Other, F for Father M for Mother. ',' Para el estudiante "Guardian Relation" use mayúscula O para Otro, F para el Padre M para la Madre.',' Pour les étudiants "Relation Gardien", utilisez la majuscule O pour Autre, F pour Père M pour Mère. ',' ছাত্রের জন্য "গার্ডিয়ান রিলেশন" অন্যের জন্য মূলধন ও ব্যবহার করুন, মায়ের জন্য ফাদার এম এর জন্য F।'],
		[ 850 , 20,'save_bulk_students',' save bulk students',' guardar estudiantes a granel',' sauver des étudiants en vrac',' বাল্ক ছাত্র সংরক্ষণ করুন'],
		[ 851 , 20,'bank_account_number ',' Bank Account Number ',' Número de cuenta bancaria ',' Numéro de compte bancaire ',' ব্যাংক একাউন্ট নম্বর'],
		[ 852 , 20,'IFSC_Code ',' IFSC Code ',' Código IFSC ',' Code IFSC ',' আইএফএসসি কোড'],
		[ 853 , 20,'payment_id',' Payment Id',' ID de pago',' ID de paiement',' পেমেন্ট আইডি'],
		[ 854 , 20,'passing_marks ',' Passing Marks ',' Marcas de paso',' Marques de passage',' পাসিং চিহ্ন '],
		[ 855 , 20,'website ',' Website ',' Sitio web ',' Site Internet ',' ওয়েবসাইট '],
		[ 856 , 20,'you_have',' You have',' Tienes',' Tu as ',' তোমার আছে '],
		[ 857 , 20,'new ',' new ',' nuevo ',' Nouveau ',' নতুন'],
		[ 858 , 20,'notification',' notification',' notificación',' notification',' প্রজ্ঞাপন '],
		[ 859 , 20,'mark_all_as_read',' Mark All As Read',' Marcar todo como leido',' Tout marquer comme lu ',' সবগুলো পঠিত বলে সনাক্ত কর '],
		[ 860 , 20,'view_profile',' view profile',' ver perfil',' Voir le profil',' প্রোফাইল দেখুন'],
		[ 861 , 20,'completed ',' Completed ',' Terminado ',' Terminé ',' সম্পন্ন '],
		[ 862 , 20,'to_do_title ',' To Do Title ',' Para hacer titulo ',' Titre à faire ',' শিরোনাম করতে'],
		[ 863 , 20,'Designation_of_Signature_person ',' Designation of Signature person ',' Designación de la persona de la firma ',' Désignation de la personne signataire ',' স্বাক্ষর ব্যক্তির নাম '],
		[ 864 , 20,'student_wise',' Student Wise',' Estudiante sabio',' Étudiant sage ',' ছাত্র বুদ্ধিমান '],
		[ 865 , 20,'print ',' print ',' impresión ',' impression',' ছাপা'],
		[ 866 , 20,'discount_of ',' Discount of ',' Descuento de',' Remise de ',' ছাড়'],
		[ 867 , 20,'applied ',' Applied ',' Aplicado',' Appliqué',' ফলিত'],
		[ 868 , 20,'fees_assign ',' Fees Assign ',' Asignar cuotas',' Affectation des frais ',' ফি বরাদ্দ করা '],
		[ NULL , 20,'background ','Background','Background','Background','Background'],
		[ NULL , 20,'style ','Style','Style','Style','Style'],
		[ NULL , 20,'color ','Color','Color','Color','Color'],
		[ NULL , 20,'select_position','Select Position','Select Position','Select Position','Select Position'],
		[ NULL , 20,'background_settings','Background Settings','Background Settings','Background Settings','Background Settings'],
		[ NULL , 20,'background_type','Background Type','Background Type','Background Type','Background Type'],
		[ NULL , 20,'course_list','Course List','Course List','Course List','Course List'],
		[ NULL , 20,'about_us','About Us','About Us','About Us','About Us'],
		[ NULL , 20,'custom_links','Custom Links','Custom Links','Custom Links','Custom Links'],
		[ NULL , 20,'operation_success_message','Operation Successful','Operation Successful','Operation Successful','Operation Successful'],
		[ NULL , 20,'home_page','Home Page','Home Page','Home Page','Home Page'],
		[ NULL , 20,'payment_id','Payment ID','Payment ID','Payment ID','Payment ID'],
		[ NULL , 20,'payment_ID','Payment ID','Payment ID','Payment ID','Payment ID'],
		[ NULL , 20,'contact','Contact','Contact','Contact','Contact'],
		[ NULL , 20,'page','Page','Page','Page','Page'], 
		[ NULL , 20,'SampleDataEmpty','Sample Data','Sample Data','Sample Data','Sample Data'],
		[ NULL , 20,'authentication_key_SID','Authentication KEY SID','Authentication KEY SID','Authentication KEY SID','Authentication KEY SID'],  
		[ NULL , 20,'validation_data','Data Validation','Data Validation','Data Validation','Data Validation'],  
		[ NULL , 6,'pending_leave_request','Pending Leave','Pending Leave','Pending Leave','Pending Leave'],  
		[ NULL , 3 ,'available_for',' Available For',' Disponible para ',' Disponible pour ',' সহজলভ্যের জন্যে '],
		[ NULL , 20 ,'login_permission','Login Permission','Login Permission','Login Permission','Login Permission'],
		[ NULL , 20 ,'profile','Profile','Profile','Profile','Profile'],

        [ NULL , 20 ,'primary_color','Primary Color','Primary Color','Primary Color','Primary Color'],
        [ NULL , 20 ,'primary_color2','Primary Color 2','Primary Color 2','Primary Color 2','Primary Color2'],
        [ NULL , 20 ,'primary_color3','Primary Color 3','Primary Color 3','Primary Color 3','Primary Color 3'],
        [ NULL , 20 ,'title_color','Title Color','Title Color','Title Color','Title Color'],
        [ NULL , 20 ,'text_color','Text Color','Text Color','Text Color','Text Color'],
        [ NULL , 20 ,'sidebar_bg','Sidebar','Sidebar','Sidebar','Sidebar'],
        [ NULL , 20 ,'theme','Theme','Theme','Theme','Theme'],


	];



	foreach ($all_translate as $row) {
		$s = new SmLanguagePhrase();
		$s->id = $row[0];
		$s->modules = $row[1];
		$s->default_phrases = trim($row[2]);
		$s->en = trim($row[3]);
		$s->es = trim($row[4]);
		$s->fr = trim($row[5]);
		$s->bn = trim($row[6]); 
		$s->save();
	}
	 



}

/**
 * Reverse the migrations.
 *
 * @return void
 */
public function down()
{
Schema::dropIfExists('sm_language_phrases');
}
}
